/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.scilab.modules.helptools.HTMLDocbookLinkResolver;
import org.scilab.modules.helptools.HTMLDocbookTagConverter;
import org.scilab.modules.helptools.SciDocMain;
import org.scilab.modules.helptools.image.ImageConverter;
import org.scilab.modules.localization.LocaleToLCID;
import org.xml.sax.SAXException;

public class CHMDocbookTagConverter
extends HTMLDocbookTagConverter {
    private StringBuilder buffer = new StringBuilder(8192);
    private String outName;
    private List<String> filesList = new ArrayList<String>();
    private String docWebsite;

    public CHMDocbookTagConverter(String string, SciDocMain sciDocMain, ImageConverter imageConverter) throws IOException, SAXException {
        super(string, sciDocMain, imageConverter);
        this.outName = new File(this.outName).getCanonicalPath() + File.separator;
        this.docWebsite = sciDocMain.getConf().getWebSiteURL();
    }

    @Override
    public void createHTMLFile(String string, String string2, String string3, String string4) {
        super.createHTMLFile(string, string2, string3, string4);
        this.filesList.add(string2);
    }

    @Override
    public String makePrevious(String string) {
        this.buffer.setLength(0);
        HTMLDocbookLinkResolver.TreeId treeId = (HTMLDocbookLinkResolver.TreeId)this.mapTreeId.get(string);
        if (treeId == null) {
            return "<link rel=\"prev\" href=\"\" title=\"\">";
        }
        HTMLDocbookLinkResolver.TreeId treeId2 = treeId.getPrevious();
        if (treeId2.parent != null) {
            this.buffer.append("<link rel=\"prev\" href=\"");
            this.buffer.append((String)this.mapId.get(treeId2.id));
            this.buffer.append("\" title=\"");
            this.buffer.append((String)this.tocitem.get(treeId2.id));
            this.buffer.append("\">");
            return this.buffer.toString();
        }
        return "<link rel=\"prev\" href=\"\" title=\"\">";
    }

    @Override
    public String makeTop(String string) {
        this.buffer.setLength(0);
        HTMLDocbookLinkResolver.TreeId treeId = (HTMLDocbookLinkResolver.TreeId)this.mapTreeId.get(string);
        if (treeId == null) {
            return "<link rel=\"up\" href=\"\" title=\"\">";
        }
        treeId = treeId.parent;
        if (treeId != null) {
            this.buffer.append("<link rel=\"up\" href=\"");
            if (!treeId.isRoot()) {
                this.buffer.append((String)this.mapId.get(treeId.id));
                this.buffer.append("\" title=\"");
                this.buffer.append((String)this.tocitem.get(treeId.id));
            } else {
                this.buffer.append(this.indexFilename);
                this.buffer.append("\" title=\"");
                this.buffer.append(this.bookTitle);
            }
            this.buffer.append("\">");
            return this.buffer.toString();
        }
        return "<link rel=\"up\" href=\"\" title=\"\">";
    }

    @Override
    public String makeNext(String string) {
        this.buffer.setLength(0);
        HTMLDocbookLinkResolver.TreeId treeId = (HTMLDocbookLinkResolver.TreeId)this.mapTreeId.get(string);
        if (treeId == null) {
            return "<link rel=\"next\" href=\"\" title=\"\">";
        }
        HTMLDocbookLinkResolver.TreeId treeId2 = treeId.getNext();
        if (treeId2 != null) {
            this.buffer.append("<link rel=\"next\" href=\"");
            this.buffer.append((String)this.mapId.get(treeId2.id));
            this.buffer.append("\" title=\"");
            this.buffer.append((String)this.tocitem.get(treeId2.id));
            this.buffer.append("\">");
            return this.buffer.toString();
        }
        return "<link rel=\"next\" href=\"\" title=\"\">";
    }

    @Override
    public String makeStart(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<link rel=\"start\" href=\"");
        this.buffer.append(this.indexFilename);
        this.buffer.append("\" title=\"");
        this.buffer.append(this.bookTitle);
        this.buffer.append("\">");
        return this.buffer.toString();
    }

    @Override
    public void endDocument() throws SAXException {
        try (FileOutputStream fileOutputStream = new FileOutputStream("toc.hhc");
             FileOutputStream fileOutputStream2 = new FileOutputStream("htmlhelp.hhp");
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream2, Charset.forName("UTF-8"));
             OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
            this.convertTree(outputStreamWriter2);
            outputStreamWriter2.flush();
            fileOutputStream.flush();
            this.convertFileList(outputStreamWriter);
            outputStreamWriter.flush();
            fileOutputStream2.flush();
        }
        catch (IOException iOException) {
            this.fatalExceptionOccurred(iOException);
        }
    }

    private void convertFileList(Appendable appendable) throws IOException {
        appendable.append("[OPTIONS]\n");
        appendable.append("Binary TOC=Yes\n");
        appendable.append("Compatibility=1.1 or later\n");
        appendable.append("Compiled file=htmlhelp.chm\n");
        appendable.append("Contents file=");
        appendable.append(this.outName);
        appendable.append("toc.hhc\n");
        appendable.append("Default Window=Main\n");
        appendable.append("Default topic=");
        appendable.append(this.outName);
        appendable.append("index.html\n");
        appendable.append("Display compile progress=Yes\n");
        appendable.append("Full-text search=Yes\n");
        appendable.append("Language=");
        appendable.append(LocaleToLCID.convert((String)this.language));
        appendable.append("\nTitle=");
        appendable.append(this.bookTitle);
        appendable.append("\nEnhanced decompilation=No\n\n");
        appendable.append("[WINDOWS]\n");
        appendable.append("Main=\"");
        appendable.append(this.bookTitle);
        appendable.append("\",\",");
        appendable.append(this.outName);
        appendable.append("toc.hhc\",,\"");
        appendable.append(this.outName);
        appendable.append("index.html\",\"");
        appendable.append(this.outName);
        appendable.append("index.html\",,,,,0x2520,,0x603006,,,,,,,,0\n\n[FILES]\n");
        for (String string : this.filesList) {
            appendable.append(this.outName);
            appendable.append(string);
            appendable.append("\n");
        }
    }

    @Override
    protected String makeRemoteLink(String string) {
        return this.docWebsite + string;
    }

    private void convertTreeId(HTMLDocbookLinkResolver.TreeId treeId, Appendable appendable) throws IOException {
        if (treeId.children != null) {
            for (HTMLDocbookLinkResolver.TreeId treeId2 : treeId.children) {
                appendable.append("<LI><OBJECT type=\"text/sitemap\">\n<param name=\"Name\" value=\"");
                appendable.append((CharSequence)this.tocitem.get(treeId2.id));
                appendable.append("\">\n<param name=\"Local\" value=\"");
                appendable.append(this.outName);
                appendable.append((CharSequence)this.mapId.get(treeId2.id));
                appendable.append("\">\n</OBJECT>\n</LI>\n");
                if (treeId2.children == null) continue;
                appendable.append("<UL>\n");
                this.convertTreeId(treeId2, appendable);
                appendable.append("</UL>\n");
            }
        }
    }

    private void convertTree(Appendable appendable) throws IOException {
        appendable.append("<HTML>\n<HEAD>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n</HEAD>\n<BODY>\n<OBJECT type=\"text/site properties\">\n<param name=\"ImageType\" value=\"Folder\">\n</OBJECT>\n");
        appendable.append("<UL>\n<LI><OBJECT type=\"text/sitemap\">\n<param name=\"Name\" value=\"");
        appendable.append(this.bookTitle);
        appendable.append("\">\n<param name=\"Local\" value=\"");
        appendable.append(this.outName);
        appendable.append("index.html\">\n</OBJECT>\n</LI>\n<UL>\n");
        this.convertTreeId(this.tree, appendable);
        appendable.append("</UL>\n</UL>\n</BODY>\n</HTML>");
    }
}

