/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.cef.browser.CefBrowser_N;
import org.cef.callback.CefDragData;

class CefDropTargetListener
implements DropTargetListener {
    private CefBrowser_N browser_;
    private CefDragData dragData_ = null;
    private int dragOperations_ = 1;
    private int dragModifiers_ = 0;
    private int acceptOperations_ = 1;

    CefDropTargetListener(CefBrowser_N cefBrowser_N) {
        this.browser_ = cefBrowser_N;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.CreateDragData(dropTargetDragEvent);
        this.browser_.dragTargetDragEnter(this.dragData_, dropTargetDragEvent.getLocation(), this.dragModifiers_, this.dragOperations_);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.AssertDragData();
        this.browser_.dragTargetDragLeave();
        this.ClearDragData();
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.AssertDragData();
        this.browser_.dragTargetDragOver(dropTargetDragEvent.getLocation(), this.dragModifiers_, this.dragOperations_);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.AssertDragData();
        this.acceptOperations_ = dropTargetDragEvent.getDropAction();
        switch (this.acceptOperations_) {
            case 0x40000000: {
                this.dragOperations_ = 2;
                this.dragModifiers_ = 6;
                break;
            }
            case 1: {
                this.dragOperations_ = 1;
                this.dragModifiers_ = 4;
                break;
            }
            case 2: {
                this.dragOperations_ = 16;
                this.dragModifiers_ = 2;
                break;
            }
            case 0: {
                this.dragOperations_ = 1;
                this.dragModifiers_ = 0;
                this.acceptOperations_ = 1;
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.AssertDragData();
        this.browser_.dragTargetDrop(dropTargetDropEvent.getLocation(), this.dragModifiers_);
        dropTargetDropEvent.acceptDrop(this.acceptOperations_);
        dropTargetDropEvent.dropComplete(true);
        this.ClearDragData();
    }

    private void CreateDragData(DropTargetDragEvent dropTargetDragEvent) {
        assert (this.dragData_ == null);
        this.dragData_ = CefDropTargetListener.createDragData(dropTargetDragEvent);
        this.dropActionChanged(dropTargetDragEvent);
    }

    private void AssertDragData() {
        assert (this.dragData_ != null);
    }

    private void ClearDragData() {
        this.dragData_ = null;
    }

    private static CefDragData createDragData(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray;
        CefDragData cefDragData = CefDragData.create();
        Transferable transferable = dropTargetDragEvent.getTransferable();
        for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
            try {
                Object object;
                if (dataFlavor.isFlavorTextType()) {
                    object = transferable.getTransferData(dataFlavor);
                    if (!(object instanceof String)) continue;
                    cefDragData.setFragmentText((String)object);
                    continue;
                }
                if (!dataFlavor.isFlavorJavaFileListType()) continue;
                object = (List)transferable.getTransferData(dataFlavor);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    cefDragData.addFile(file.getPath(), file.getName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return cefDragData;
    }
}

