/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefDevToolsMessageObserver;
import org.cef.browser.CefRegistration;

public class CefDevToolsClient
implements AutoCloseable {
    private final Map<Integer, CompletableFuture<String>> queuedCommands_ = Collections.synchronizedMap(new HashMap());
    private final Set<EventListener> eventListeners_ = Collections.synchronizedSet(new LinkedHashSet());
    private CefRegistration registration_;
    private final CefBrowser_N browser_;

    CefDevToolsClient(CefBrowser_N cefBrowser_N) {
        this.browser_ = cefBrowser_N;
        this.registration_ = cefBrowser_N.addDevToolsMessageObserver(new CefDevToolsMessageObserver(){

            @Override
            public void onDevToolsMethodResult(CefBrowser cefBrowser, int n, boolean bl, String string) {
                CompletableFuture<String> completableFuture = CefDevToolsClient.this.getQueuedCommand(n);
                if (bl) {
                    completableFuture.complete(string);
                } else {
                    completableFuture.completeExceptionally(new DevToolsException("DevTools method failed", string));
                }
            }

            @Override
            public void onDevToolsEvent(CefBrowser cefBrowser, String string, String string2) {
                for (EventListener eventListener : CefDevToolsClient.this.eventListeners_) {
                    eventListener.onEvent(string, string2);
                }
            }
        });
    }

    @Override
    public void close() {
        this.queuedCommands_.clear();
        this.eventListeners_.clear();
        this.registration_ = null;
    }

    public boolean isClosed() {
        return this.registration_ == null;
    }

    private CompletableFuture<String> getQueuedCommand(Integer n2) {
        return this.queuedCommands_.computeIfAbsent(n2, n -> new CompletableFuture());
    }

    public CompletableFuture<String> executeDevToolsMethod(String string) {
        return this.executeDevToolsMethod(string, null);
    }

    public CompletableFuture<String> executeDevToolsMethod(String string, String string2) {
        if (this.isClosed()) {
            CompletableFuture<String> completableFuture = new CompletableFuture<String>();
            completableFuture.completeExceptionally(new DevToolsException("Client is closed"));
            return completableFuture;
        }
        return this.browser_.executeDevToolsMethod(string, string2).thenCompose(this::getQueuedCommand);
    }

    public void addEventListener(EventListener eventListener) {
        this.eventListeners_.add(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.eventListeners_.remove(eventListener);
    }

    public static final class DevToolsException
    extends Exception {
        private static final long serialVersionUID = 3952948449841375372L;
        private final String json_;

        public DevToolsException(String string) {
            this(string, (String)null);
        }

        public DevToolsException(String string, String string2) {
            super(string);
            this.json_ = string2;
        }

        @Override
        public String getMessage() {
            Object object = super.getMessage();
            if (this.json_ != null) {
                object = (String)object + ": " + this.json_;
            }
            return object;
        }

        public String getJson() {
            return this.json_;
        }
    }

    public static interface EventListener {
        public void onEvent(String var1, String var2);
    }
}

