/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

public class OS {
    private static OSType osType = OSType.OSUndefined;

    public static final boolean isWindows() {
        return OS.getOSType() == OSType.OSWindows;
    }

    public static final boolean isMacintosh() {
        return OS.getOSType() == OSType.OSMacintosh;
    }

    public static final boolean isLinux() {
        return OS.getOSType() == OSType.OSLinux;
    }

    private static final OSType getOSType() {
        if (osType == OSType.OSUndefined) {
            String string = System.getProperty("os.name").toLowerCase();
            osType = string.startsWith("windows") ? OSType.OSWindows : (string.startsWith("linux") ? OSType.OSLinux : (string.startsWith("mac") ? OSType.OSMacintosh : OSType.OSUnknown));
        }
        return osType;
    }

    private static enum OSType {
        OSUndefined,
        OSLinux,
        OSWindows,
        OSMacintosh,
        OSUnknown;

    }
}

