/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Desktop;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.swing.JOptionPane;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;

public final class WebBrowser
implements XConfigurationListener {
    private static final String ERROR_MSG = Messages.gettext((String)"Could not open: ");
    public static final String WEBPATH = "//web/body/web";
    private static WebPreferences webprefs;
    private static Document doc;

    private WebBrowser() {
    }

    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        Set set = xConfigurationEvent.getModifiedPaths();
        if (set.contains("ALL") || set.contains(WEBPATH)) {
            webprefs = null;
            doc = null;
        }
    }

    public static void openUrl(URL uRL, String string) {
        if (uRL == null) {
            JOptionPane.showMessageDialog(null, ERROR_MSG + string);
        } else {
            WebBrowser.openUrl(uRL.toString());
        }
    }

    public static void openUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (webprefs == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            webprefs = ((WebPreferences[])XConfiguration.get(WebPreferences.class, (Document)doc, (String)WEBPATH))[0];
        }
        try {
            String string2 = WebBrowser.getProtocol(string);
            if (string2 == null) {
                if (string.charAt(0) == '<') {
                    String string3 = "mailto:" + string.substring(1, string.length() - 1);
                    if (WebBrowser.webprefs.defaultMailer) {
                        Desktop.getDesktop().mail(new URI(string3));
                    } else {
                        Runtime.getRuntime().exec(WebBrowser.webprefs.cmdMailer + " " + new URI(string3).toString());
                    }
                }
            } else if (string2.equals("mailto")) {
                if (WebBrowser.webprefs.defaultMailer) {
                    Desktop.getDesktop().mail(new URI(string));
                } else {
                    Runtime.getRuntime().exec(WebBrowser.webprefs.cmdMailer + " " + new URI(string).toString());
                }
            } else if (WebBrowser.webprefs.defaultBrowser) {
                Desktop.getDesktop().browse(new URI(string));
            } else {
                Runtime.getRuntime().exec(WebBrowser.webprefs.cmdBrowser + " " + new URI(string).toString());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, ERROR_MSG + string);
        }
    }

    private static String getProtocol(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    static {
        XConfiguration.addXConfigurationListener((XConfigurationListener)new WebBrowser());
    }

    @XConfiguration.XConfAttribute
    static class WebPreferences {
        boolean defaultBrowser;
        boolean defaultMailer;
        String cmdBrowser;
        String cmdMailer;

        private WebPreferences() {
        }

        @XConfiguration.XConfAttribute(tag="web", attributes={"default-browser", "default-mailer", "command-browser", "command-mailer"})
        private void set(boolean bl, boolean bl2, String string, String string2) {
            this.defaultBrowser = bl;
            this.defaultMailer = bl2;
            this.cmdBrowser = string;
            this.cmdMailer = string2;
        }
    }
}

