/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.gui.ScilabKeyStroke;

public final class ScilabSwingUtilities {
    protected ScilabSwingUtilities() {
        throw new UnsupportedOperationException();
    }

    public static void removeFromParent(Component component) {
        final Component component2 = component;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    component2.setVisible(false);
                    Container container = component2.getParent();
                    if (container != null) {
                        container.remove(component2);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getCause().printStackTrace();
        }
    }

    public static Cursor createCursorFromIcon(String string, String string2) {
        File file = new File(string);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        Image image = null;
        if (dimension.width == bufferedImage.getWidth() || dimension.height == bufferedImage.getHeight()) {
            image = bufferedImage;
        } else if (bufferedImage.getWidth() < dimension.width && bufferedImage.getHeight() < dimension.height) {
            int n;
            int n2;
            BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 2);
            for (n2 = 0; n2 < bufferedImage2.getWidth(); ++n2) {
                for (n = 0; n < bufferedImage2.getHeight(); ++n) {
                    bufferedImage2.setRGB(n2, n, 0);
                }
            }
            for (n2 = 0; n2 < bufferedImage.getWidth(); ++n2) {
                for (n = 0; n < bufferedImage.getHeight(); ++n) {
                    bufferedImage2.setRGB(n2, n, bufferedImage.getRGB(n2, n));
                }
            }
            image = bufferedImage2;
        } else {
            image = bufferedImage.getScaledInstance(dimension.width, dimension.height, 4);
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), string2);
    }

    public static void closeOnEscape(final Window window) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        KeyStroke keyStroke2 = ScilabKeyStroke.getKeyStroke((String)"OSSCKEY W");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowListener[] windowListenerArray = window.getWindowListeners();
                for (int i = 0; i < windowListenerArray.length; ++i) {
                    windowListenerArray[i].windowClosing(new WindowEvent(window, 201));
                }
                window.setVisible(false);
                window.dispose();
            }
        };
        if (window instanceof JFrame) {
            ((JFrame)window).getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
            ((JFrame)window).getRootPane().registerKeyboardAction(actionListener, keyStroke2, 2);
        } else if (window instanceof JWindow) {
            ((JWindow)window).getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
            ((JWindow)window).getRootPane().registerKeyboardAction(actionListener, keyStroke2, 2);
        } else if (window instanceof JDialog) {
            ((JDialog)window).getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
            ((JDialog)window).getRootPane().registerKeyboardAction(actionListener, keyStroke2, 2);
        }
    }
}

