/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.PrintRequestAttributeSet;

public class ScilabPrint
implements Printable {
    private static final int PRINT_MARGIN = 3;
    private BufferedImage canvasDump;
    private PrinterJob pj;

    public ScilabPrint(BufferedImage bufferedImage, PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
        this.canvasDump = bufferedImage;
        this.pj = printerJob;
        PageFormat pageFormat = this.pj.defaultPage();
        this.pj.setPrintable(this, pageFormat);
        try {
            this.pj.print(printRequestAttributeSet);
        }
        catch (PrinterException printerException) {
            System.out.println("Printing Error");
            System.err.println(printerException.toString());
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        ((Graphics2D)graphics).drawRenderedImage(this.canvasDump, affineTransform);
        return 0;
    }
}

