/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.gui.filechooser.FileChooserInfos;
import org.scilab.modules.localization.Messages;

public class SciFileFilter
extends FileFilter {
    private String mask;
    private String description;
    private int filterIndex;
    private String[] extensions;

    public SciFileFilter(String string, String string2, int n) {
        if (string2 == null) {
            if (string.equals("*.sci")) {
                this.extensions = new String[]{"sci"};
                this.description = Messages.gettext((String)"Scilab SCI files") + "(*.sci)";
            } else if (string.equals("*.sce")) {
                this.extensions = new String[]{"sce"};
                this.description = Messages.gettext((String)"Scilab SCE files") + "(*.sce)";
            } else if (string.equals("*.bin")) {
                this.extensions = new String[]{"bin"};
                this.description = Messages.gettext((String)"Scilab binary files") + "(*.bin)";
            } else if (string.equals("*.sc*")) {
                this.extensions = new String[]{"sci", "sce"};
                this.description = Messages.gettext((String)"All Scilab files") + "(*.sc*)";
            } else if (string.equals("*.ssp")) {
                this.extensions = new String[]{"ssp"};
                this.description = Messages.gettext((String)"Xcos files") + "(*.ssp)";
            } else if (string.equals("*.zcos")) {
                this.extensions = new String[]{"zcos"};
                this.description = Messages.gettext((String)"Xcos files") + "(*.zcos)";
            } else if (string.equals("*.xcos")) {
                this.extensions = new String[]{"xcos"};
                this.description = Messages.gettext((String)"Xcos files") + "(*.xcos)";
            } else if (string.equals("*.cos*")) {
                this.extensions = new String[]{"cosf"};
                this.description = Messages.gettext((String)"Scicos files") + "(*.cos*)";
            } else if (string.equals("*.tst")) {
                this.extensions = new String[]{"tst"};
                this.description = Messages.gettext((String)"Test files") + "(*.tst)";
            } else if (string.equals("*.start")) {
                this.extensions = new String[]{"start"};
                this.description = Messages.gettext((String)"Scilab Start files") + "(*.start)";
            } else if (string.equals("*.quit")) {
                this.extensions = new String[]{"quit"};
                this.description = Messages.gettext((String)"Scilab Quit files") + "(*.quit)";
            } else if (string.equals("*.dem")) {
                this.extensions = new String[]{"dem"};
                this.description = Messages.gettext((String)"Scilab Demo files") + "(*.dem)";
            } else if (string.equals("all")) {
                this.extensions = new String[]{"sci", "sce", "tst", "start", "quit", "dem"};
                this.description = Messages.gettext((String)"All Scilab files") + "(*.sci,*.sce,*.tst,*.start,*.quit,*.dem)";
            } else if (string.equals("*.pdf")) {
                this.extensions = new String[]{"pdf"};
                this.description = Messages.gettext((String)"All PDF files") + "(*.pdf)";
            } else if (string.equals("*.ps")) {
                this.extensions = new String[]{"ps"};
                this.description = Messages.gettext((String)"All Postscript files") + "(*.ps)";
            } else if (string.equals("*.eps")) {
                this.extensions = new String[]{"eps"};
                this.description = Messages.gettext((String)"All Encapsulated PS files") + "(*.eps)";
            } else if (string.equals("*.png")) {
                this.extensions = new String[]{"png"};
                this.description = Messages.gettext((String)"All PNG image files") + "(*.png)";
            } else if (string.equals("*.rtf")) {
                this.extensions = new String[]{"rtf"};
                this.description = Messages.gettext((String)"All RTF (Rich Text Format) files") + "(*.rtf)";
            } else if (string.equals("*.html")) {
                this.extensions = new String[]{"html"};
                this.description = Messages.gettext((String)"All HTML files") + "(*.html)";
            } else if (string.equals("*.*")) {
                this.extensions = new String[]{""};
                this.description = Messages.gettext((String)"All files") + "(*.*)";
            } else {
                this.extensions = new String[]{string.substring(string.lastIndexOf(".") + 1)};
                this.description = String.format(Messages.gettext((String)"All %s files"), string);
            }
        } else {
            this.description = string2;
            if (string.matches("\\*\\.[a-z]+")) {
                this.extensions = new String[]{string.substring(2)};
            }
        }
        if (string.equals("all")) {
            string = "(*.sci)|(*.sce)|(*.tst)|(*.start)|(*.quit)|(*.dem)";
        }
        this.mask = string.replaceAll("\\.", "\\\\.");
        this.mask = this.mask.replaceAll("\\*", ".\\*");
        this.filterIndex = n;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1 || n == string.length() - 1) {
            return new String("");
        }
        return string.substring(n);
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.mask.equals("")) {
            return true;
        }
        if (this.mask.equals(".*\\..*")) {
            int n = this.filterIndex + 1;
            FileChooserInfos.getInstance().setFilterIndex(n);
            return true;
        }
        int n = this.filterIndex + 1;
        FileChooserInfos.getInstance().setFilterIndex(n);
        if (this.isWindows()) {
            Pattern pattern = Pattern.compile(this.mask + "$", 66);
            Matcher matcher = pattern.matcher(file.getName());
            return matcher.find();
        }
        return file.getName().matches(this.mask + "$");
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

