/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor.action;

import java.util.LinkedList;
import org.scilab.modules.gui.editor.action.Action;
import org.scilab.modules.gui.editor.action.ActionHistory;

public class EditorHistory
implements ActionHistory {
    LinkedList<Action> history = new LinkedList();
    int head = -1;
    private static final int MAX_HISTORY_SIZE = 100;

    @Override
    public void addAction(Action action) {
        Action action2;
        while (this.head > 0) {
            action2 = this.history.pollFirst();
            action2.dispose();
            --this.head;
        }
        if (this.history.size() == 100) {
            action2 = this.history.pollLast();
            action2.dispose();
        }
        this.history.addFirst(action);
    }

    @Override
    public void undo() {
        Action action = this.history.get(this.head);
        if (action.exists()) {
            action.undo();
            ++this.head;
        } else {
            this.history.remove(this.head);
        }
    }

    @Override
    public void redo() {
        if (this.head > 0) {
            --this.head;
            Action action = this.history.get(this.head);
            if (action.exists()) {
                action.redo();
            } else {
                Action action2 = this.history.get(this.head);
                action2.dispose();
                this.history.remove(this.head);
            }
        }
    }

    @Override
    public void removeAction() {
        this.history.pollLast();
    }

    @Override
    public void dispose() {
        for (Action action : this.history) {
            action.dispose();
        }
        this.history.clear();
    }

    public boolean isUndoEnabled() {
        return this.history.size() > 0 && this.head < this.history.size() && this.head >= 0;
    }

    public boolean isRedoEnabled() {
        return this.history.size() > 0 && this.head > 0 && this.head <= this.history.size();
    }
}

