/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import org.scilab.modules.renderer.utils.AxesHandler;
import org.scilab.modules.renderer.utils.CommonHandler;
import org.scilab.modules.renderer.utils.ObjectSearcher;

public class ScilabClipboard {
    static ScilabClipboard instance = null;
    Integer objectUid = null;
    boolean needDuplication = false;
    Integer copyStyle;

    public static ScilabClipboard getInstance() {
        if (instance == null) {
            instance = new ScilabClipboard();
        }
        return instance;
    }

    public void copy(Integer n) {
        this.objectUid = n;
        this.needDuplication = true;
    }

    public Integer paste(Integer n, Integer[] integerArray) {
        Integer n2 = this.objectUid;
        if (!this.canPaste()) {
            return null;
        }
        Integer n3 = new ObjectSearcher().searchParent(n2, Integer.valueOf(1));
        if (n3 == null) {
            return null;
        }
        if (this.needDuplication) {
            n2 = CommonHandler.duplicate((Integer)this.objectUid);
        } else {
            CommonHandler.cut((Integer)n2);
        }
        Integer n4 = AxesHandler.clickedAxes((Integer)n, (Integer[])integerArray)[0];
        if (n4 != null) {
            AxesHandler.setAxesVisible((Integer)n4);
            CommonHandler.insert((Integer)n4, (Integer)n2);
            AxesHandler.axesBound((Integer)n3, (Integer)n4);
            if (!this.needDuplication) {
                this.objectUid = null;
            }
            return n2;
        }
        n4 = AxesHandler.duplicateAxes((Integer)n3);
        if (n4 != null) {
            CommonHandler.insert((Integer)n4, (Integer)n2);
            AxesHandler.axesBound((Integer)n3, (Integer)n4);
            if (!this.needDuplication) {
                this.objectUid = null;
            }
            return n2;
        }
        return null;
    }

    public void cut(Integer n) {
        this.objectUid = n;
        this.needDuplication = false;
    }

    public boolean canPaste() {
        if (!CommonHandler.objectExists((Integer)this.objectUid).booleanValue()) {
            this.objectUid = null;
            return false;
        }
        return true;
    }

    public Integer getCurrentObject() {
        return this.objectUid;
    }

    public boolean canPasteStyle() {
        if (!CommonHandler.objectExists((Integer)this.copyStyle).booleanValue()) {
            this.copyStyle = null;
            return false;
        }
        return true;
    }

    public void copyStyle(Integer n) {
        this.copyStyle = n;
    }

    public Integer pasteStyle(Integer n, boolean bl) {
        if (!this.canPasteStyle()) {
            return null;
        }
        Integer n2 = AxesHandler.cloneAxesWithStyle((Integer)this.copyStyle);
        Integer n3 = CommonHandler.getParentFigure((Integer)this.copyStyle);
        Integer n4 = CommonHandler.getParentFigure((Integer)n);
        CommonHandler.cloneColorMap((Integer)n3, (Integer)n4);
        CommonHandler.cloneBackgroundColor((Integer)n3, (Integer)n4);
        AxesHandler.pasteAxesStyle((Integer)n2, (Integer)n, (boolean)true);
        if (bl) {
            AxesHandler.axesBound((Integer)this.copyStyle, (Integer)n2);
        }
        return n2;
    }
}

