/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.uiimage;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.uiimage.SimpleUiImage;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;

public class SwingScilabUiImage
extends JLabel
implements SwingViewObject,
SimpleUiImage {
    private static final long serialVersionUID = -3394912554085956130L;
    private Integer uid;
    private ImageIcon imi;
    private Image img;
    private String imageFile;
    private int imageWidth;
    private int imageHeight;
    private double[] scale;
    private double[] shear;
    private double angle;
    private Border defaultBorder = null;

    public SwingScilabUiImage() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.scale = new double[2];
        this.shear = new double[2];
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.setHorizontalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.setVerticalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setText(String string) {
        this.imageFile = string;
        File file = new File(this.imageFile);
        if (!file.exists()) {
            String string2 = FindIconHelper.findImage((String)this.imageFile);
            file = new File(string2);
        }
        try {
            this.imi = new ImageIcon(ImageIO.read(file));
            this.img = this.imi.getImage();
            this.setIcon(this.imi);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setEmptyText() {
        this.imageFile = null;
        this.imi = null;
        this.img = null;
        this.setIcon(null);
    }

    @Override
    public void setRotate(double d) {
        this.angle = d;
        this.updateImage();
    }

    @Override
    public void setShear(double[] dArray) {
        this.shear = dArray;
        this.updateImage();
    }

    @Override
    public void setScale(double[] dArray) {
        this.scale = dArray;
        this.updateImage();
    }

    private void updateImage() {
        if (this.img != null && this.img.getHeight(this) >= 0 && this.img.getWidth(this) >= 0) {
            this.imageWidth = (int)Math.ceil((double)this.img.getWidth(this) * this.scale[0]);
            this.imageHeight = (int)Math.ceil((double)this.img.getHeight(this) * this.scale[1]);
            BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.fillRect(0, 0, this.imageWidth, this.imageHeight);
            graphics2D.shear(this.shear[0], this.shear[1]);
            graphics2D.rotate(Math.toRadians(this.angle), this.imageWidth / 2, this.imageHeight / 2);
            graphics2D.drawImage(this.img, 0, 0, this.imageWidth, this.imageHeight, this);
            this.setIcon(new ImageIcon(bufferedImage));
        }
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        switch (n) {
            case 317: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length == 0) {
                    return;
                }
                double[] dArray = new double[]{doubleArray.length < 1 ? 1.0 : doubleArray[0], doubleArray.length < 2 ? 1.0 : doubleArray[1], doubleArray.length < 3 ? 0.0 : doubleArray[2], doubleArray.length < 4 ? 0.0 : doubleArray[3], doubleArray.length < 5 ? 0.0 : doubleArray[4]};
                double[] dArray2 = new double[]{dArray[0], dArray[1]};
                this.setScale(dArray2);
                double[] dArray3 = new double[]{dArray[2], dArray[3]};
                this.setShear(dArray3);
                this.setRotate(dArray[4]);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Label.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Label.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

