/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.uidisplaytree;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.gui.bridge.tree.SwingScilabTree;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.tree.ScilabDisplayTree;
import org.scilab.modules.gui.uidisplaytree.SimpleUiDisplayTree;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;

public class SwingScilabUiDisplayTree
extends JScrollPane
implements SimpleUiDisplayTree {
    private static final long serialVersionUID = -1L;
    private JLabel label;
    private SwingScilabTree sst;
    private Border defaultBorder = null;

    @Override
    public void setFont(Font font) {
        this.getLabel().setFont(font);
    }

    @Override
    public Font getFont() {
        return this.getLabel().getFont();
    }

    @Override
    public Color getForeground() {
        return this.getLabel().getForeground();
    }

    @Override
    public void setForeground(Color color) {
        this.getLabel().setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        this.getLabel().setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.getLabel().getBackground();
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.getLabel().setHorizontalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.getLabel().setVerticalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
        }
        return this.label;
    }

    @Override
    public String getText() {
        return this.getLabel().getText();
    }

    @Override
    public void setText(String string) {
        this.getLabel().setText(string);
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    @Override
    public void setData(String[] stringArray) {
        this.sst = new SwingScilabTree(ScilabDisplayTree.uicontrolScilabDisplayTree(stringArray));
        this.getViewport().add(this.sst.getJTree());
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollPane.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollPane.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

