/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.slider;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scilab.modules.commons.OS;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabSlider
extends JSlider
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -4262320156090829309L;
    private static final int MINIMUM_VALUE = 0;
    private static final int MAX_MAXIMUM_VALUE = 10000;
    private int MAXIMUM_VALUE = 10000;
    private Integer uid;
    private CommonCallBack callback;
    private ChangeListener changeListener;
    private Border defaultBorder = null;
    private double previousUserValueCallback = Double.POSITIVE_INFINITY;

    public SwingScilabSlider() {
        this.setOpaque(true);
        this.setMinimum(0);
        this.setMaximum(this.MAXIMUM_VALUE);
        this.setValue(0);
        this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "LeftAction");
        this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "LeftAction");
        this.getActionMap().put("LeftAction", new LeftAction());
        this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "RightAction");
        this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "RightAction");
        this.getActionMap().put("RightAction", new RightAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlRightAction");
        this.getInputMap().put(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlRightAction");
        this.getActionMap().put("CtrlRightAction", new CtrlRightAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlLeftAction");
        this.getInputMap().put(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlLeftAction");
        this.getActionMap().put("CtrlLeftAction", new CtrlLeftAction());
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                double d = Math.abs(SwingScilabSlider.this.getUserValue() - SwingScilabSlider.this.previousUserValueCallback);
                SwingScilabSlider.this.previousUserValueCallback = SwingScilabSlider.this.getUserValue();
                if (d != 0.0) {
                    SwingScilabSlider.this.updateModel();
                    if (SwingScilabSlider.this.callback != null) {
                        SwingScilabSlider.this.callback.actionPerformed(null);
                    }
                }
            }
        };
        this.addChangeListener(this.changeListener);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2 = mouseWheelEvent.getWheelRotation();
                int n3 = n = mouseWheelEvent.isControlDown() ? SwingScilabSlider.this.getMajorTickSpacing() : SwingScilabSlider.this.getMinorTickSpacing();
                if (n2 < 0) {
                    SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() + n);
                } else {
                    SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() - n);
                }
            }
        });
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(super.getSize().width, super.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        super.setSize(size.getWidth(), size.getHeight());
        super.doLayout();
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public void setText(String string) {
        this.setName(string);
    }

    @Override
    public void setEmptyText() {
        this.setName(null);
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    public void setMajorTickSpacing(double d) {
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 306);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 305);
        double d4 = (double)(this.MAXIMUM_VALUE - 0) / (d3 - d2);
        int n = (int)(d * d4);
        super.setMajorTickSpacing(n);
    }

    public void setMinorTickSpacing(double d) {
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 306);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 305);
        double d4 = (double)(this.MAXIMUM_VALUE - 0) / (d3 - d2);
        int n = (int)(d * d4);
        super.setMinorTickSpacing(n);
    }

    public void setVertical() {
        this.setOrientation(1);
    }

    public void setHorizontal() {
        this.setOrientation(0);
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    private double getUserValue() {
        double d = (Double)GraphicController.getController().getProperty(this.uid, 306);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 305);
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(this.uid, 314);
        double d3 = d + (double)(this.getValue() - 0) * (d2 - d) / (double)(this.MAXIMUM_VALUE - 0);
        if (this.getSnapToTicks()) {
            d3 = Math.min(d + (double)Math.round((d3 - d) / doubleArray[0]) * doubleArray[0], d2);
        }
        return d3;
    }

    public void setUserValue(double d) {
        this.removeChangeListener(this.changeListener);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 306);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 305);
        this.setValue(0 + (int)Math.round((d - d2) * (double)(this.MAXIMUM_VALUE - 0) / (d3 - d2)));
        this.addChangeListener(this.changeListener);
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 305: {
                Double d = (Double)object;
                Double d2 = (Double)graphicController.getProperty(this.uid, 306);
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 314);
                this.updateSwingSlider(d2, d, doubleArray);
                break;
            }
            case 306: {
                Double d = (Double)object;
                Double d3 = (Double)graphicController.getProperty(this.uid, 305);
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 314);
                this.updateSwingSlider(d, d3, doubleArray);
                break;
            }
            case 80: {
                Double[] doubleArray = SwingViewWidget.updatePosition(this, this.uid, object);
                if (doubleArray[2].intValue() > doubleArray[3].intValue()) {
                    this.setHorizontal();
                    break;
                }
                this.setVertical();
                break;
            }
            case 314: {
                Double[] doubleArray = (Double[])object;
                Double d = (Double)graphicController.getProperty(this.uid, 306);
                Double d4 = (Double)graphicController.getProperty(this.uid, 305);
                this.updateSwingSlider(d, d4, doubleArray);
                break;
            }
            case 315: {
                Boolean bl = (Boolean)object;
                this.setSnapToTicks(bl);
                break;
            }
            case 317: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length != 0) {
                    this.setUserValue(doubleArray[0]);
                    break;
                }
                Double d = (Double)graphicController.getProperty(this.uid, 306);
                this.setUserValue(d);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    private void updateSwingSlider(Double d, Double d2, Double[] doubleArray) {
        double d3 = doubleArray[0];
        double d4 = doubleArray[1];
        this.MAXIMUM_VALUE = 10000 - 10000 % Math.min(Math.max(1, (int)Math.abs((d2 - d) / d3)), 10000);
        this.removeChangeListener(this.changeListener);
        this.setMaximum(this.MAXIMUM_VALUE);
        this.setMinorTickSpacing(d3);
        this.setMajorTickSpacing(d4);
        this.addChangeListener(this.changeListener);
        this.updateModel();
    }

    private void updateModel() {
        Double[] doubleArray = new Double[]{this.getUserValue()};
        GraphicController.getController().setProperty(this.uid, 317, (Object)doubleArray);
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Slider.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Slider.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    static {
        if (OS.get() == OS.UNIX) {
            UIManager.put("Slider.paintValue", false);
        }
    }

    class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 2099826485447918397L;

        LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() - SwingScilabSlider.this.getMinorTickSpacing());
        }
    }

    class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = 8666161246122371904L;

        RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() + SwingScilabSlider.this.getMinorTickSpacing());
        }
    }

    class CtrlRightAction
    extends AbstractAction {
        private static final long serialVersionUID = -1364255463511656338L;

        CtrlRightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() + SwingScilabSlider.this.getMajorTickSpacing());
        }
    }

    class CtrlLeftAction
    extends AbstractAction {
        private static final long serialVersionUID = -3289281207742516486L;

        CtrlLeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() - SwingScilabSlider.this.getMajorTickSpacing());
        }
    }
}

