/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.messagebox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.messagebox.SimpleMessageBox;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tab.Tab;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.WebBrowser;
import org.scilab.modules.localization.Messages;

public class SwingScilabMessageBox
extends JDialog
implements SimpleMessageBox,
ActionListener {
    private static final long serialVersionUID = 7939976395338222763L;
    private static final int X_MESSAGE_TYPE = 0;
    private static final int X_DIALOG_TYPE = 1;
    private static final int X_CHOOSE_TYPE = 2;
    private static final int X_MDIALOG_TYPE = 3;
    private static final int X_CHOICES_TYPE = 4;
    private static final String NEW_LINE = "\n";
    private static final String SEPARATOR = "[--sep--]";
    private static final int X_MDIALOG_TEXTFIELD_SIZE = 10;
    private final Icon scilabIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab", (String)"48x48"));
    private final Icon passwdIcon = new ImageIcon(FindIconHelper.findIcon((String)"emblem-readonly", (String)"48x48"));
    private final Icon hourglassIcon = new ImageIcon(FindIconHelper.findIcon((String)"process-working"));
    private int elementId;
    private Icon messageIcon;
    private int scilabDialogType = 0;
    private Component parentWindow;
    private final JButton btnOK = new JButton(Messages.gettext((String)"OK"));
    private final JButton btnCancel = new JButton(Messages.gettext((String)"Cancel"));
    private JTextArea textArea;
    private String initialValue;
    private int initialValueSize;
    private String userValue;
    private JPasswordField passwordTextField;
    private int[] isPassword;
    private JList listBox;
    private String[] listboxItems;
    private int selectedItem;
    private String[] lineLabels;
    private String[] columnLabels;
    private String[] defaultInput;
    private Component[] textFields;
    private String[] userValues;
    private String[] buttonsLabels;
    private int selectedButton;
    private int[] defaultSelectedButtons;
    private ButtonGroup[] buttonGroups;
    private int[] userSelectedButtons;
    private String message;
    private String title;
    private final Image imageForIcon = ((ImageIcon)this.scilabIcon).getImage();
    private int messageType = -1;
    private Component[] objs;
    private Object[] buttons;
    private boolean modal = true;
    private JCheckBox checkbox;

    public SwingScilabMessageBox() {
        this.setIconImage(this.imageForIcon);
    }

    @Override
    public void setElementId(int n) {
        this.elementId = n;
    }

    @Override
    public int getElementId() {
        return this.elementId;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public void setMessage(String[] stringArray) {
        int n = 0;
        this.message = "<HTML>";
        for (n = 0; n < stringArray.length - 1; ++n) {
            this.message = this.message + "<div>" + stringArray[n] + "</div>";
        }
        this.message = this.message + stringArray[n] + "</HTML>";
    }

    @Override
    public void setPasswordMode(int[] nArray) {
        this.isPassword = nArray;
    }

    public void setCheckbox(String string, Action action) {
        this.checkbox = new JCheckBox(action);
        this.checkbox.setText(string);
    }

    @Override
    public void displayAndWait() {
        int n;
        JButton jButton = null;
        super.setTitle(this.title);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setOpaque(false);
        jTextPane.setBorder(null);
        jTextPane.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jTextPane.getEditorKit();
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        String string = "body {font-family:\"" + font.getName() + "\"; font-size:\"" + font.getSize() + "pt\"}";
        styleSheet.addRule(string);
        hTMLEditorKit.setStyleSheet(styleSheet);
        jTextPane.setEditorKit(hTMLEditorKit);
        jTextPane.setText(this.message);
        jTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    WebBrowser.openUrl(hyperlinkEvent.getURL(), hyperlinkEvent.getDescription());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        if (this.scilabDialogType == 4) {
            Serializable serializable;
            this.objs = new Component[2];
            this.objs[0] = jScrollPane;
            int n2 = 0;
            int n3 = 0;
            n = 0;
            var11_20 = new ArrayList<Integer>();
            for (int i = 0; i < this.lineLabels.length; ++i) {
                if (!this.lineLabels[i].equals(SEPARATOR)) {
                    ++n2;
                    continue;
                }
                if (n2 > n) {
                    n = n2;
                }
                var11_20.add(n2);
                n2 = 0;
                ++n3;
            }
            var11_20.add(n2);
            ++n3;
            var12_23 = new JPanel(new GridBagLayout());
            var13_25 = new GridBagConstraints();
            ((GridBagConstraints)var13_25).gridx = 0;
            ((GridBagConstraints)var13_25).gridy = 0;
            ((GridBagConstraints)var13_25).fill = 2;
            this.buttonGroups = new ButtonGroup[n3];
            this.userSelectedButtons = new int[n3];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n4 = 0; n4 < this.lineLabels.length; ++n4) {
                ((GridBagConstraints)var13_25).weightx = 1.0;
                ((Container)var12_23).add((Component)new JLabel(this.lineLabels[n4]), var13_25);
                ++((GridBagConstraints)var13_25).gridx;
                n6 = 0;
                ++n4;
                serializable = new ButtonGroup();
                while (n4 < this.lineLabels.length && !this.lineLabels[n4].equals(SEPARATOR)) {
                    JToggleButton jToggleButton = new JToggleButton(this.lineLabels[n4]);
                    if (++n6 == this.defaultSelectedButtons[n5]) {
                        jToggleButton.setSelected(true);
                    }
                    if (n6 == (Integer)var11_20.get(n5) - 1 && this.defaultSelectedButtons[n5] > (Integer)var11_20.get(n5) - 1) {
                        jToggleButton.setSelected(true);
                    }
                    ((ButtonGroup)serializable).add(jToggleButton);
                    ((GridBagConstraints)var13_25).weightx = 0.0;
                    ((Container)var12_23).add((Component)jToggleButton, var13_25);
                    ++((GridBagConstraints)var13_25).gridx;
                    ++n4;
                }
                for (int i = ((Integer)var11_20.get(n5)).intValue(); i < n; ++i) {
                    ((Container)var12_23).add((Component)new JLabel(), var13_25);
                    ++((GridBagConstraints)var13_25).gridx;
                }
                this.buttonGroups[n5] = serializable;
                ++n5;
                ((GridBagConstraints)var13_25).gridx = 0;
                ++((GridBagConstraints)var13_25).gridy;
            }
            ((Container)var12_23).doLayout();
            serializable = new JScrollPane((Component)var12_23);
            this.objs[1] = serializable;
            this.buttons = new Object[2];
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            if (this.isWindows()) {
                this.buttons[0] = this.btnOK;
                this.buttons[1] = this.btnCancel;
            } else {
                this.buttons[0] = this.btnCancel;
                this.buttons[1] = this.btnOK;
            }
            jButton = this.btnOK;
        } else if (this.scilabDialogType == 3) {
            int n7;
            Object object;
            int n8;
            JLabel[] jLabelArray;
            this.objs = new Component[2];
            this.objs[0] = jScrollPane;
            int n9 = 0;
            n9 = this.columnLabels == null ? 2 : this.columnLabels.length + 1;
            if (this.columnLabels != null) {
                jLabelArray = new JLabel[this.columnLabels.length + 1];
                jLabelArray[0] = new JLabel("");
                for (n8 = 0; n8 < this.columnLabels.length; ++n8) {
                    jLabelArray[n8 + 1] = new JLabel(this.columnLabels[n8]);
                }
            } else {
                jLabelArray = null;
            }
            JLabel[] jLabelArray2 = new JLabel[this.lineLabels.length];
            for (n8 = 0; n8 < this.lineLabels.length; ++n8) {
                jLabelArray2[n8] = new JLabel(this.lineLabels[n8] + " ");
            }
            if (this.columnLabels == null) {
                this.userValues = new String[this.lineLabels.length];
                this.textFields = new Component[this.lineLabels.length];
            } else {
                this.userValues = new String[this.lineLabels.length * this.columnLabels.length];
                this.textFields = new Component[this.lineLabels.length * this.columnLabels.length];
            }
            for (n8 = 0; n8 < this.lineLabels.length; ++n8) {
                for (int i = 0; i < n9 - 1; ++i) {
                    var13_25 = this.defaultInput[i * this.lineLabels.length + n8];
                    if ("%T".equalsIgnoreCase((String)var13_25)) {
                        object = new JCheckBox();
                        ((JCheckBox)object).setSelected(true);
                    } else if ("%F".equalsIgnoreCase((String)var13_25)) {
                        object = new JCheckBox();
                        ((JCheckBox)object).setSelected(false);
                    } else if (this.isPassword != null && this.isPassword[i * this.lineLabels.length + n8] != 0) {
                        object = new JPasswordField((String)var13_25);
                        if (((String)var13_25).length() < 10) {
                            ((JPasswordField)object).setColumns(10);
                        }
                    } else {
                        object = new JTextField((String)var13_25);
                        if (((String)var13_25).length() < 10) {
                            ((JTextField)object).setColumns(10);
                        }
                    }
                    this.textFields[i * this.lineLabels.length + n8] = object;
                    jLabelArray2[n8].setLabelFor((Component)object);
                }
            }
            var11_20 = new JPanel();
            var12_23 = new GroupLayout((Container)var11_20);
            ((Container)var11_20).setLayout((LayoutManager)var12_23);
            var13_25 = ((GroupLayout)var12_23).createSequentialGroup().addContainerGap();
            object = ((GroupLayout)var12_23).createSequentialGroup().addContainerGap();
            GroupLayout.ParallelGroup parallelGroup = ((GroupLayout)var12_23).createParallelGroup(GroupLayout.Alignment.LEADING);
            if (jLabelArray != null) {
                parallelGroup.addComponent(jLabelArray[0]);
            }
            for (int i = 0; i < this.lineLabels.length; ++i) {
                parallelGroup.addComponent(jLabelArray2[i]);
            }
            ((GroupLayout.SequentialGroup)var13_25).addGroup(parallelGroup);
            ((GroupLayout.SequentialGroup)var13_25).addGap(18, 18, 18);
            for (int i = 0; i < n9 - 1; ++i) {
                if (i > 0) {
                    ((GroupLayout.SequentialGroup)var13_25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                }
                GroupLayout.ParallelGroup parallelGroup2 = ((GroupLayout)var12_23).createParallelGroup(GroupLayout.Alignment.CENTER);
                if (jLabelArray != null) {
                    parallelGroup2.addComponent(jLabelArray[i + 1]);
                }
                for (n7 = 0; n7 < this.lineLabels.length; ++n7) {
                    parallelGroup2.addComponent(this.textFields[i * this.lineLabels.length + n7]);
                }
                ((GroupLayout.SequentialGroup)var13_25).addGroup(parallelGroup2);
            }
            ((GroupLayout)var12_23).setHorizontalGroup(((GroupLayout)var12_23).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout.SequentialGroup)var13_25).addContainerGap()));
            if (jLabelArray != null) {
                GroupLayout.ParallelGroup parallelGroup3 = ((GroupLayout)var12_23).createParallelGroup(GroupLayout.Alignment.BASELINE);
                for (int i = 0; i < n9; ++i) {
                    parallelGroup3.addComponent(jLabelArray[i]);
                }
                ((GroupLayout.SequentialGroup)object).addGroup(parallelGroup3);
                ((GroupLayout.SequentialGroup)object).addGap(18, 18, 18);
            }
            for (int i = 0; i < this.lineLabels.length; ++i) {
                if (i > 0) {
                    ((GroupLayout.SequentialGroup)object).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                }
                GroupLayout.ParallelGroup parallelGroup4 = ((GroupLayout)var12_23).createParallelGroup(GroupLayout.Alignment.BASELINE);
                parallelGroup4.addComponent(jLabelArray2[i]);
                for (n7 = 0; n7 < n9 - 1; ++n7) {
                    parallelGroup4.addComponent(this.textFields[n7 * this.lineLabels.length + i]);
                }
                ((GroupLayout.SequentialGroup)object).addGroup(parallelGroup4);
            }
            ((GroupLayout)var12_23).setVerticalGroup(((GroupLayout)var12_23).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout.SequentialGroup)object).addContainerGap()));
            JScrollPane jScrollPane2 = new JScrollPane((Component)var11_20);
            this.objs[1] = jScrollPane2;
            this.buttons = new Object[2];
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            if (this.isWindows()) {
                this.buttons[0] = this.btnOK;
                this.buttons[1] = this.btnCancel;
            } else {
                this.buttons[0] = this.btnCancel;
                this.buttons[1] = this.btnOK;
            }
            jButton = this.btnOK;
        } else if (this.scilabDialogType == 2) {
            this.objs = new Component[2];
            this.objs[0] = jScrollPane;
            this.objs[1] = this.createXchooseListBox();
            this.buttons = new Object[2];
            if (this.buttonsLabels != null) {
                this.btnCancel.setText(this.buttonsLabels[0]);
            }
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            this.buttons[0] = this.btnCancel;
            this.buttons[1] = this.btnOK;
        } else if (this.scilabDialogType == 1) {
            this.objs = new Component[2];
            this.objs[0] = jScrollPane;
            if (this.isPassword[0] != 0) {
                this.passwordTextField = new JPasswordField(this.initialValue);
                this.objs[1] = this.passwordTextField;
            } else {
                this.textArea = new JTextArea(this.initialValue);
                this.textArea.setRows(this.initialValueSize);
                JScrollPane jScrollPane3 = new JScrollPane(this.textArea);
                this.objs[1] = jScrollPane3;
            }
            this.buttons = new Object[2];
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            if (this.isWindows()) {
                this.buttons[0] = this.btnOK;
                this.buttons[1] = this.btnCancel;
            } else {
                this.buttons[0] = this.btnCancel;
                this.buttons[1] = this.btnOK;
            }
            jButton = this.btnOK;
        } else {
            int n10 = this.checkbox == null ? 1 : 2;
            this.objs = new Component[n10];
            this.objs[0] = jScrollPane;
            if (n10 == 2) {
                this.objs[1] = this.checkbox;
            }
            if (this.buttonsLabels == null) {
                this.buttons = new Object[1];
                this.btnOK.addActionListener(this);
                this.buttons[0] = this.btnOK;
                jButton = this.btnOK;
            } else {
                this.buttons = new Object[this.buttonsLabels.length];
                for (int i = 0; i < this.buttonsLabels.length; ++i) {
                    JButton jButton2 = new JButton(this.buttonsLabels[i]);
                    jButton2.addActionListener(this);
                    if (i == 0) {
                        jButton = jButton2;
                    }
                    if (this.isWindows()) {
                        this.buttons[i] = jButton2;
                        continue;
                    }
                    this.buttons[this.buttonsLabels.length - i - 1] = jButton2;
                }
            }
        }
        ((JScrollPane)this.objs[0]).setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.objs.length > 1) {
            jPanel.add(this.objs[0], "North");
        } else {
            jPanel.add(this.objs[0], "Center");
        }
        if (this.objs.length == 2) {
            jPanel.add(this.objs[1], "Center");
        }
        if (this.objs.length > 2) {
            JPanel jPanel2 = new JPanel();
            for (n = 1; n < this.objs.length; ++n) {
                jPanel2.add(this.objs[n]);
            }
            jPanel.add((Component)jPanel2, "Center");
        }
        if (this.messageType != -1) {
            this.setContentPane(new JOptionPane(jPanel, this.messageType, 2, null, this.buttons));
        } else {
            if (this.messageIcon == null) {
                this.messageIcon = this.scilabIcon;
            }
            this.setContentPane(new JOptionPane(jPanel, this.messageType, 2, this.messageIcon, this.buttons));
        }
        this.pack();
        if (this.modal) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        } else if (this.scilabDialogType != 0) {
            this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        } else {
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
        if (this.parentWindow == null) {
            if (ScilabConsole.isExistingConsole()) {
                this.setLocationRelativeTo((Component)((Object)ScilabConsole.getConsole().getAsSimpleConsole()));
            }
        } else {
            this.setLocationRelativeTo(this.parentWindow);
        }
        ScilabSwingUtilities.closeOnEscape(this);
        if (jButton != null) {
            this.getRootPane().setDefaultButton(jButton);
            jButton.requestFocusInWindow();
        }
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOK) {
            if (this.scilabDialogType == 1) {
                this.userValue = this.isPassword[0] != 0 ? new String(this.passwordTextField.getPassword()) : this.textArea.getText();
            } else if (this.scilabDialogType == 3) {
                for (int i = 0; i < this.textFields.length; ++i) {
                    Component component = this.textFields[i];
                    if (component instanceof JPasswordField) {
                        this.userValues[i] = new String(((JPasswordField)component).getPassword());
                        continue;
                    }
                    if (component instanceof JTextField) {
                        this.userValues[i] = ((JTextField)component).getText();
                        continue;
                    }
                    if (!(component instanceof JCheckBox)) continue;
                    this.userValues[i] = ((JCheckBox)component).isSelected() ? "%t" : "%f";
                }
                this.userValue = "";
            } else if (this.scilabDialogType == 4) {
                for (int i = 0; i < this.buttonGroups.length; ++i) {
                    Enumeration<AbstractButton> enumeration = this.buttonGroups[i].getElements();
                    for (int j = 0; j < this.buttonGroups[i].getButtonCount(); ++j) {
                        JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
                        if (jToggleButton.getModel() != this.buttonGroups[i].getSelection()) continue;
                        this.userSelectedButtons[i] = j + 1;
                    }
                }
                this.userValue = "";
            } else if (this.scilabDialogType == 2) {
                this.selectedItem = this.listBox.getSelectedIndex() + 1;
            }
            this.selectedButton = 1;
        } else if (actionEvent.getSource() == this.btnCancel) {
            this.selectedButton = 2;
        } else if (this.buttonsLabels != null) {
            for (int i = 0; i < this.buttonsLabels.length; ++i) {
                if (!((JButton)actionEvent.getSource()).getText().equals(this.buttonsLabels[i])) continue;
                this.selectedButton = i + 1;
                break;
            }
        }
        this.dispose();
    }

    @Override
    public int getSelectedButton() {
        return this.selectedButton;
    }

    @Override
    public void setDefaultSelectedButtons(int[] nArray) {
        this.defaultSelectedButtons = nArray;
        this.scilabDialogType = 4;
    }

    @Override
    public int[] getUserSelectedButtons() {
        return this.userSelectedButtons;
    }

    @Override
    public void setButtonsLabels(String[] stringArray) {
        this.buttonsLabels = stringArray;
    }

    @Override
    public void setInitialValue(String[] stringArray) {
        int n = 0;
        this.initialValue = "";
        for (n = 0; n < stringArray.length - 1; ++n) {
            this.initialValue = this.initialValue + stringArray[n] + NEW_LINE;
        }
        this.initialValue = this.initialValue + stringArray[n];
        this.initialValueSize = stringArray.length;
        this.scilabDialogType = 1;
    }

    @Override
    public String[] getValue() {
        if (this.scilabDialogType == 3) {
            return this.userValues;
        }
        return this.userValue.split(NEW_LINE);
    }

    @Override
    public int getValueSize() {
        if (this.userValue == null) {
            return 0;
        }
        return this.userValue.split(NEW_LINE).length;
    }

    @Override
    public void setListBoxItems(String[] stringArray) {
        this.listboxItems = stringArray;
        this.scilabDialogType = 2;
    }

    @Override
    public int getSelectedItem() {
        return this.selectedItem;
    }

    private JScrollPane createXchooseListBox() {
        this.listBox = new JList();
        this.listBox.setLayoutOrientation(0);
        this.listBox.setModel(new DefaultListModel());
        this.listBox.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SwingScilabMessageBox.this.selectedItem = SwingScilabMessageBox.this.listBox.getSelectedIndex() + 1;
                    SwingScilabMessageBox.this.dispose();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        ((DefaultListModel)this.listBox.getModel()).clear();
        for (int i = 0; i < this.listboxItems.length; ++i) {
            ((DefaultListModel)this.listBox.getModel()).addElement(this.listboxItems[i]);
        }
        this.listBox.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.listBox);
        return jScrollPane;
    }

    @Override
    public void setLineLabels(String[] stringArray) {
        this.scilabDialogType = 3;
        this.lineLabels = stringArray;
    }

    @Override
    public void setColumnLabels(String[] stringArray) {
        this.columnLabels = stringArray;
    }

    @Override
    public void setDefaultInput(String[] stringArray) {
        this.defaultInput = stringArray;
    }

    @Override
    public void setModal(boolean bl) {
        this.modal = bl;
    }

    @Override
    public void setIcon(String string) {
        if (string.equals("error")) {
            this.messageType = 0;
        } else if (string.equals("hourglass")) {
            this.messageIcon = this.hourglassIcon;
        } else if (string.equals("info")) {
            this.messageType = 1;
        } else if (string.equals("passwd")) {
            this.messageIcon = this.passwdIcon;
        } else if (string.equals("question")) {
            this.messageType = 3;
        } else if (string.equals("warning")) {
            this.messageType = 2;
        } else {
            this.messageIcon = this.scilabIcon;
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    @Override
    public void setParentForLocation(SimpleTab simpleTab) {
        this.parentWindow = simpleTab != null ? (Component)((Object)simpleTab) : null;
    }

    public void setParentForLocation(Component component) {
        this.parentWindow = component;
    }

    public void setParentForLocation(Tab tab) {
        this.setParentForLocation((Component)((Object)tab.getAsSimpleTab()));
    }
}

