/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.frame;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.frame.SwingScilabFrame;
import org.scilab.modules.gui.bridge.frame.SwingScilabScrollableFrame;

public class SwingScilabLayer
extends SwingScilabFrame {
    private static final long serialVersionUID = 9038916804095320758L;
    private ArrayList<Integer> layers = new ArrayList();

    public SwingScilabLayer() {
        this.setLayout(new CardLayout());
        this.hasLayout = true;
    }

    public void addMember(SwingScilabFrame swingScilabFrame) {
        String string = swingScilabFrame.getId().toString();
        swingScilabFrame.setName(string);
        this.layers.add(0, swingScilabFrame.getId());
        this.add((Component)swingScilabFrame, string);
        this.revalidate();
        this.setActiveLayer(1);
    }

    public void addMember(SwingScilabScrollableFrame swingScilabScrollableFrame) {
        String string = swingScilabScrollableFrame.getId().toString();
        swingScilabScrollableFrame.setName(string);
        this.layers.add(0, swingScilabScrollableFrame.getId());
        this.add((Component)swingScilabScrollableFrame, string);
        this.revalidate();
        this.setActiveLayer(1);
    }

    public Integer getActiveLayer() {
        Component component = null;
        for (Component component2 : this.getComponents()) {
            if (!component2.isVisible()) continue;
            component = component2;
            break;
        }
        if (component == null) {
            return -1;
        }
        return this.layers.indexOf(Integer.parseInt(component.getName())) + 1;
    }

    private Component getLayerFromIndex(Integer n) {
        if (n == null || n < 1 || n > this.getComponentCount()) {
            return null;
        }
        return this.getComponent(this.getComponentCount() - n);
    }

    private Integer getLayerIndex(Component component) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != component) continue;
            return i + 1;
        }
        return -1;
    }

    public Boolean isLayerActive(Integer n) {
        return this.getActiveLayer().equals(n);
    }

    public Boolean isLayerActive(Component component) {
        Integer n = this.getLayerIndex(component);
        if (n == -1) {
            return false;
        }
        return this.isLayerActive(this.getComponentCount() - (n - 1));
    }

    public void removeMember(SwingScilabScrollableFrame swingScilabScrollableFrame) {
        this.layers.remove(swingScilabScrollableFrame.getId());
        this.remove(swingScilabScrollableFrame);
        this.revalidate();
        Integer n = this.getActiveLayer();
        if (n == -1 && this.setActiveLayer(1)) {
            n = 1;
        }
    }

    public void removeMember(SwingScilabFrame swingScilabFrame) {
        this.layers.remove(swingScilabFrame.getId());
        this.remove(swingScilabFrame);
        this.revalidate();
        Integer n = this.getActiveLayer();
        if (n == -1 && this.setActiveLayer(1)) {
            n = 1;
        }
    }

    public boolean setActiveLayer(Integer n) {
        if (n < 1 || n > this.layers.size()) {
            return false;
        }
        Integer n2 = this.getActiveLayer();
        if (!this.setActiveLayer(this.layers.get(n - 1).toString())) {
            return false;
        }
        Integer n3 = this.getActiveLayer();
        this.updateModelProperties(n2, n3);
        return true;
    }

    private boolean setActiveLayer(String string) {
        ((CardLayout)this.getLayout()).show(this, string);
        return true;
    }

    public boolean setActiveLayerFromName(String string) {
        GraphicController graphicController = GraphicController.getController();
        for (int i = 0; i < this.layers.size(); ++i) {
            String string2 = (String)graphicController.getProperty(this.layers.get(i), 99);
            if (!string2.equals(string)) continue;
            return this.setActiveLayer(i + 1);
        }
        return false;
    }

    public void updateModelProperties(Integer n, Integer n2) {
        SwingViewObject swingViewObject = (SwingViewObject)((Object)this.getLayerFromIndex(n));
        SwingViewObject swingViewObject2 = (SwingViewObject)((Object)this.getLayerFromIndex(n2));
        String string = null;
        if (swingViewObject != null) {
            GraphicController.getController().setProperty(swingViewObject.getId(), 27, (Object)false);
        }
        if (swingViewObject2 != null) {
            GraphicController.getController().setProperty(swingViewObject2.getId(), 27, (Object)true);
            string = (String)GraphicController.getController().getProperty(swingViewObject2.getId(), 99);
        }
        GraphicController.getController().setProperty(this.getId(), 318, (Object)new Double[]{n2.doubleValue()});
        GraphicController.getController().setProperty(this.getId(), 309, (Object)new String[]{string});
    }
}

