/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_export.FileExporter;
import org.scilab.modules.gui.bridge.filechooser.ExportData;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.localization.Messages;

public class ExportOptionWindow
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final ExportData exportData;
    private Window parentWindow;
    private SimpleTab parentTab;
    private JDialog optionDialog;
    private JRadioButton portrait;
    private JRadioButton landscape;
    private JButton confirmOption;
    private JButton abortOption;

    public ExportOptionWindow(ExportData exportData) {
        this.exportData = exportData;
    }

    public void displayOptionWindow(SimpleTab simpleTab) {
        this.parentTab = simpleTab;
        this.parentWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, (JComponent)((Object)simpleTab));
        this.optionDialog = new JDialog(this.parentWindow);
        this.optionDialog.setTitle(String.format(Messages.gettext((String)"Option for %s format"), this.exportData.getExportExtension().toUpperCase()));
        this.optionDialog.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"scilab")).getImage());
    }

    public void landscapePortraitOption() {
        this.portrait = new JRadioButton(Messages.gettext((String)"Portrait"), true);
        this.landscape = new JRadioButton(Messages.gettext((String)"Landscape"), false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.portrait);
        buttonGroup.add(this.landscape);
        this.confirmOption = new JButton(Messages.gettext((String)"Confirm"));
        this.abortOption = new JButton(Messages.gettext((String)"Cancel"));
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), String.format(" %s ", Messages.gettext((String)"Orientation"))));
        jPanel2.add(this.portrait);
        jPanel2.add(this.landscape);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.confirmOption);
        jPanel3.add(this.abortOption);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.optionDialog.add(jPanel);
        this.optionDialog.pack();
        this.portrait.addActionListener(this);
        this.landscape.addActionListener(this);
        this.confirmOption.addActionListener(this);
        this.abortOption.addActionListener(this);
        this.optionDialog.setModal(true);
        this.optionDialog.setResizable(false);
        this.optionDialog.setLocationRelativeTo(this.parentWindow);
        this.optionDialog.setVisible(true);
    }

    public String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.portrait.isSelected();
        Vector<String> vector = new Vector<String>();
        if (actionEvent.getSource() == this.confirmOption) {
            if (bl) {
                vector.add("portrait");
            } else {
                vector.add("landscape");
            }
            this.exportData.setExportProperties(vector);
            this.optionDialog.dispose();
            Integer n = this.exportData.getFigureId();
            Object object = this.exportData.getExportName();
            if (this.getExtension((String)object) == null) {
                object = (String)object + "." + this.exportData.getExportExtension();
            }
            int n2 = this.exportData.getExportProperties().elementAt(0).equalsIgnoreCase("landscape") ? 1 : 0;
            Cursor cursor = this.parentWindow.getCursor();
            this.parentWindow.setCursor(Cursor.getPredefinedCursor(3));
            String string = FileExporter.fileExport((int)n, (String)object, (String)this.exportData.getExportExtension(), (float)1.0f, (int)n2);
            this.parentWindow.setCursor(cursor);
            if (string.length() != 0) {
                ScilabModalDialog.show(this.parentTab, String.format(Messages.gettext((String)"An error occurred during export: %s"), string), Messages.gettext((String)"Export error"), ScilabModalDialog.IconType.ERROR_ICON);
            }
        }
        if (actionEvent.getSource() == this.abortOption) {
            this.optionDialog.dispose();
        }
    }
}

