/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.scilab.modules.gui.colorchooser.SimpleColorChooser;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;

public class SwingScilabColorChooser
extends JDialog
implements SimpleColorChooser {
    private static final long serialVersionUID = 1L;
    private static final int HGAP = 10;
    private static final int VGAP = 2;
    private int elementId;
    private Color selectedColor;
    private final JColorChooser colorChooser;

    public SwingScilabColorChooser(Color color) {
        super(new JFrame(), "Color Chooser", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Color"));
        this.colorChooser = new JColorChooser();
        jPanel.add(this.colorChooser);
        if (color != null) {
            this.colorChooser.setColor(color);
        }
        this.getContentPane().add(jPanel);
        ScilabSwingUtilities.closeOnEscape(this);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton jButton = new JButton("Ok");
        jPanel3.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingScilabColorChooser.this.selectedColor = SwingScilabColorChooser.this.colorChooser.getColor();
                SwingScilabColorChooser.this.dispose();
                SwingScilabColorChooser.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jPanel3.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingScilabColorChooser.this.selectedColor = null;
                SwingScilabColorChooser.this.dispose();
                SwingScilabColorChooser.this.setVisible(false);
            }
        });
        jPanel2.add(jPanel3);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void setElementId(int n) {
        this.elementId = n;
    }

    @Override
    public int getElementId() {
        return this.elementId;
    }

    @Override
    public Color getSelectedColor() {
        return this.selectedColor;
    }

    @Override
    public void setDefaultColor(Color color) {
        this.colorChooser.setColor(color);
    }

    @Override
    public void displayAndWait() {
        this.setVisible(true);
    }
}

