/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.scilab.modules.graphic_export.Driver;
import org.scilab.modules.graphic_objects.DataLoader;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.gui.SwingViewMenu;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.browser.SwingScilabBrowser;
import org.scilab.modules.gui.bridge.checkbox.SwingScilabCheckBox;
import org.scilab.modules.gui.bridge.checkboxmenuitem.SwingScilabCheckBoxMenuItem;
import org.scilab.modules.gui.bridge.console.SwingScilabConsole;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.bridge.editbox.SwingScilabEditBox;
import org.scilab.modules.gui.bridge.editbox.SwingScilabSpinner;
import org.scilab.modules.gui.bridge.frame.SwingScilabFrame;
import org.scilab.modules.gui.bridge.frame.SwingScilabLayer;
import org.scilab.modules.gui.bridge.frame.SwingScilabScrollableFrame;
import org.scilab.modules.gui.bridge.label.SwingScilabLabel;
import org.scilab.modules.gui.bridge.listbox.SwingScilabListBox;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.popupmenu.SwingScilabPopupMenu;
import org.scilab.modules.gui.bridge.pushbutton.SwingScilabPushButton;
import org.scilab.modules.gui.bridge.radiobutton.SwingScilabRadioButton;
import org.scilab.modules.gui.bridge.slider.SwingScilabScroll;
import org.scilab.modules.gui.bridge.slider.SwingScilabSlider;
import org.scilab.modules.gui.bridge.tab.SwingScilabAxes;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabStaticPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabTabGroup;
import org.scilab.modules.gui.bridge.uiimage.SwingScilabUiImage;
import org.scilab.modules.gui.bridge.uitable.SwingScilabUiTable;
import org.scilab.modules.gui.bridge.waitbar.SwingScilabWaitBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.ged.Inspector;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.BorderConvertor;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.Debug;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.gui.widget.Widget;
import org.scilab.modules.renderer.utils.textRendering.FontManager;

public final class SwingView
implements GraphicView {
    public static final String NULLUUID = new UUID(0L, 0L).toString();
    private static SwingView me;
    private static boolean headless;
    private Map<Integer, TypedObject> allObjects;
    private static final Set<Integer> managedTypes;

    private SwingView() {
        GraphicController.getController().register((GraphicView)this);
        this.allObjects = Collections.synchronizedMap(new HashMap());
        try {
            GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getDefault()));
            gLCanvas.getContext().makeCurrent();
            GL gL = gLCanvas.getGL();
            DataLoader.setABGRExt((int)(gL.isExtensionAvailable("GL_EXT_abgr") ? 1 : 0));
            gLCanvas.getContext().release();
            gLCanvas = null;
            FontManager.getSciFontManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerSwingView() {
        Debug.DEBUG("SwingView", "calling registerSwingView()");
        if (me == null) {
            me = new SwingView();
        }
    }

    public static void setHeadless(boolean bl) {
        headless = bl;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static SwingViewObject getFromId(Integer n) {
        TypedObject typedObject = SwingView.me.allObjects.get(n);
        if (typedObject == null) {
            return null;
        }
        return typedObject.getValue();
    }

    public static int getSize() {
        return SwingView.me.allObjects.size();
    }

    public void createObject(Integer n) {
        int n2 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (!managedTypes.contains(n2)) {
            return;
        }
        boolean bl = (Boolean)GraphicController.getController().getProperty(n, 79);
        if (!bl) {
            return;
        }
        if (!headless && !GraphicsEnvironment.isHeadless()) {
            Debug.DEBUG("SwingWiew", "Object Created : " + n + "with type : " + n2);
            if (n2 != 19) {
                this.allObjects.put(n, this.CreateObjectFromType(n2, n));
                return;
            }
            if (n2 == 19) {
                int n3 = (Integer)GraphicController.getController().getProperty(n, 279);
                Debug.DEBUG("SwingView", "__GO_STYLE__(" + n3 + ")");
                this.allObjects.put(n, this.CreateObjectFromType(n3, n));
            }
        } else if (n2 == 8) {
            Driver.setDefaultVisitor((int)n);
        }
    }

    private UielementType StyleToEnum(int n) {
        Debug.DEBUG("SwingView", "StyleToEnum(" + n + ")");
        switch (n) {
            case 8: {
                return UielementType.Figure;
            }
            case 1: {
                return UielementType.Axes;
            }
            case 330: {
                return UielementType.Console;
            }
            case 280: {
                return UielementType.CheckBox;
            }
            case 281: {
                return UielementType.Edit;
            }
            case 282: {
                return UielementType.Spinner;
            }
            case 283: {
                return UielementType.Frame;
            }
            case 285: {
                return UielementType.Image;
            }
            case 286: {
                return UielementType.ListBox;
            }
            case 287: {
                return UielementType.PopupMenu;
            }
            case 288: {
                return UielementType.PushButton;
            }
            case 289: {
                return UielementType.RadioButton;
            }
            case 290: {
                return UielementType.Slider;
            }
            case 291: {
                return UielementType.Table;
            }
            case 292: {
                return UielementType.Text;
            }
            case 20: {
                return UielementType.UiChildMenu;
            }
            case 321: {
                return UielementType.UiParentMenu;
            }
            case 322: {
                return UielementType.UiChildMenu;
            }
            case 323: {
                return UielementType.UiCheckedMenu;
            }
            case 335: {
                return UielementType.Progressbar;
            }
            case 334: {
                return UielementType.Waitbar;
            }
            case 21: {
                return UielementType.UiContextMenu;
            }
            case 372: {
                return UielementType.Tab;
            }
            case 293: {
                return UielementType.Layer;
            }
            case 412: {
                return UielementType.Browser;
            }
        }
        return null;
    }

    private TypedObject CreateObjectFromType(int n, final Integer n2) {
        final UielementType uielementType = this.StyleToEnum(n);
        final SwingViewObject[] swingViewObjectArray = new SwingViewObject[1];
        if (SwingUtilities.isEventDispatchThread()) {
            swingViewObjectArray[0] = this.CreateObjectFromType(uielementType, n2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        swingViewObjectArray[0] = SwingView.this.CreateObjectFromType(uielementType, n2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return new TypedObject(uielementType, swingViewObjectArray[0]);
    }

    private SwingViewObject CreateObjectFromType(UielementType uielementType, Integer n) {
        switch (uielementType) {
            case CheckBox: {
                SwingScilabCheckBox swingScilabCheckBox = new SwingScilabCheckBox();
                swingScilabCheckBox.setId(n);
                this.setDefaultProperties(swingScilabCheckBox, n);
                return swingScilabCheckBox;
            }
            case Console: {
                Console console = (Console)GraphicController.getController().getObjectFromId(n);
                if (console.getScilabMode() == Console.ScilabMode.STD) {
                    WindowsConfigurationManager.restoreUUID(NULLUUID);
                    SwingScilabConsole swingScilabConsole = (SwingScilabConsole)ScilabConsole.getConsole().getAsSimpleConsole();
                    SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)((Object)swingScilabConsole.getParent());
                    swingScilabDockablePanel.setId(n);
                    return swingScilabDockablePanel;
                }
                return null;
            }
            case Edit: {
                SwingScilabEditBox swingScilabEditBox = new SwingScilabEditBox();
                swingScilabEditBox.setId(n);
                this.setDefaultProperties(swingScilabEditBox, n);
                return swingScilabEditBox;
            }
            case Spinner: {
                SwingScilabSpinner swingScilabSpinner = new SwingScilabSpinner();
                swingScilabSpinner.setId(n);
                this.setDefaultProperties(swingScilabSpinner, n);
                return swingScilabSpinner;
            }
            case Figure: {
                SwingScilabPanel swingScilabPanel;
                Object object;
                Figure figure = (Figure)GraphicController.getController().getObjectFromId(n);
                String string = figure.getName();
                Integer n2 = figure.getId();
                if (string != null && n2 != null) {
                    string = string.replaceFirst("%d", n2.toString());
                }
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow(figure.getDockable());
                swingScilabWindow.setTitle(string);
                Integer[] integerArray = figure.getSize();
                swingScilabWindow.setDims(new Size(integerArray[0], integerArray[1]));
                if (figure.getDockable().booleanValue()) {
                    object = new SwingScilabDockablePanel(string, n2, figure);
                    ClosingOperationsManager.addDependencyWithRoot((SwingScilabDockablePanel)object);
                    swingScilabPanel = object;
                } else {
                    swingScilabPanel = new SwingScilabStaticPanel(string, n2, figure);
                }
                swingScilabPanel.setId(n);
                object = ScilabMenuBar.createMenuBar();
                object.setVisible(false);
                swingScilabPanel.setMenuBar((MenuBar)object);
                swingScilabWindow.addMenuBar((MenuBar)object);
                ToolBar toolBar = ScilabToolBar.createToolBar();
                toolBar.setVisible(false);
                swingScilabPanel.setToolBar(toolBar);
                swingScilabWindow.addToolBar(toolBar);
                TextBox textBox = ScilabTextBox.createTextBox();
                textBox.setVisible(false);
                swingScilabPanel.setInfoBar(textBox);
                swingScilabWindow.addInfoBar(textBox);
                if (figure.getDockable().booleanValue()) {
                    DockingManager.dock((Component)((Object)((SwingScilabDockablePanel)swingScilabPanel)), (DockingPort)swingScilabWindow.getDockingPort());
                    ActiveDockableTracker.requestDockableActivation((Component)((Object)((SwingScilabDockablePanel)swingScilabPanel)));
                } else {
                    swingScilabWindow.addTab(swingScilabPanel);
                }
                swingScilabPanel.setWindowIcon("graphic-window");
                swingScilabPanel.setParentWindowId(swingScilabWindow.getId());
                swingScilabPanel.setEventHandler(figure.getEventHandlerString());
                swingScilabPanel.setEventHandlerEnabled(figure.getEventHandlerEnable());
                swingScilabPanel.setVisible(true);
                swingScilabPanel.setName(string);
                String string2 = figure.getInfoMessage();
                if (string2 == null || string2.length() == 0) {
                    textBox.setText("");
                } else {
                    textBox.setText(string2);
                }
                swingScilabPanel.update(80, GraphicController.getController().getProperty(n, 80));
                String string3 = (String)GraphicController.getController().getProperty(n, 329);
                if (string3 != null && !string3.equals("")) {
                    swingScilabPanel.update(329, string3);
                }
                swingScilabWindow.pack();
                swingScilabWindow.setVisible(figure.getVisible());
                return swingScilabPanel;
            }
            case Axes: {
                SwingScilabAxes swingScilabAxes = new SwingScilabAxes();
                return swingScilabAxes;
            }
            case Frame: {
                Boolean bl = (Boolean)GraphicController.getController().getProperty(n, 403);
                if (bl.booleanValue()) {
                    SwingScilabScrollableFrame swingScilabScrollableFrame = new SwingScilabScrollableFrame();
                    swingScilabScrollableFrame.setId(n);
                    this.setDefaultProperties(swingScilabScrollableFrame, n);
                    Integer n3 = (Integer)GraphicController.getController().getProperty(n, 386);
                    if (n3 != 0) {
                        swingScilabScrollableFrame.setBorder(BorderConvertor.getBorder(n3));
                    }
                    return swingScilabScrollableFrame;
                }
                SwingScilabFrame swingScilabFrame = new SwingScilabFrame();
                swingScilabFrame.setId(n);
                this.setDefaultProperties(swingScilabFrame, n);
                Integer n4 = (Integer)GraphicController.getController().getProperty(n, 386);
                if (n4 != 0) {
                    swingScilabFrame.setBorder(BorderConvertor.getBorder(n4));
                }
                return swingScilabFrame;
            }
            case Image: {
                SwingScilabUiImage swingScilabUiImage = new SwingScilabUiImage();
                swingScilabUiImage.setId(n);
                this.setDefaultProperties(swingScilabUiImage, n);
                return swingScilabUiImage;
            }
            case ListBox: {
                SwingScilabListBox swingScilabListBox = new SwingScilabListBox();
                swingScilabListBox.setId(n);
                this.setDefaultProperties(swingScilabListBox, n);
                return swingScilabListBox;
            }
            case PopupMenu: {
                SwingScilabPopupMenu swingScilabPopupMenu = new SwingScilabPopupMenu();
                swingScilabPopupMenu.setId(n);
                this.setDefaultProperties(swingScilabPopupMenu, n);
                return swingScilabPopupMenu;
            }
            case Progressbar: {
                SwingScilabWaitBar swingScilabWaitBar = new SwingScilabWaitBar();
                swingScilabWaitBar.setIndeterminateMode(true);
                swingScilabWaitBar.setId(n);
                return swingScilabWaitBar;
            }
            case PushButton: {
                SwingScilabPushButton swingScilabPushButton = new SwingScilabPushButton();
                swingScilabPushButton.setId(n);
                this.setDefaultProperties(swingScilabPushButton, n);
                String string = (String)GraphicController.getController().getProperty(n, 329);
                if (string != null && !string.equals("")) {
                    swingScilabPushButton.update(329, string);
                }
                return swingScilabPushButton;
            }
            case RadioButton: {
                SwingScilabRadioButton swingScilabRadioButton = new SwingScilabRadioButton();
                swingScilabRadioButton.setId(n);
                this.setDefaultProperties(swingScilabRadioButton, n);
                return swingScilabRadioButton;
            }
            case Slider: {
                if (Console.getConsole().getUseDeprecatedLF()) {
                    SwingScilabScroll swingScilabScroll = new SwingScilabScroll();
                    swingScilabScroll.setId(n);
                    this.setDefaultProperties(swingScilabScroll, n);
                    return swingScilabScroll;
                }
                SwingScilabSlider swingScilabSlider = new SwingScilabSlider();
                swingScilabSlider.setId(n);
                this.setDefaultProperties(swingScilabSlider, n);
                return swingScilabSlider;
            }
            case Table: {
                SwingScilabUiTable swingScilabUiTable = new SwingScilabUiTable();
                swingScilabUiTable.setId(n);
                this.setDefaultProperties(swingScilabUiTable, n);
                return swingScilabUiTable;
            }
            case Text: {
                SwingScilabLabel swingScilabLabel = new SwingScilabLabel();
                swingScilabLabel.setId(n);
                this.setDefaultProperties(swingScilabLabel, n);
                String string = (String)GraphicController.getController().getProperty(n, 329);
                if (string != null && !string.equals("")) {
                    swingScilabLabel.update(329, string);
                }
                return swingScilabLabel;
            }
            case Uimenu: {
                throw new UnsupportedOperationException();
            }
            case UiParentMenu: {
                SwingScilabMenu swingScilabMenu = new SwingScilabMenu();
                swingScilabMenu.setId(n);
                this.setMenuDefaultProperties(swingScilabMenu, n);
                return swingScilabMenu;
            }
            case UiChildMenu: {
                SwingScilabMenuItem swingScilabMenuItem = new SwingScilabMenuItem();
                swingScilabMenuItem.setId(n);
                this.setMenuDefaultProperties(swingScilabMenuItem, n);
                return swingScilabMenuItem;
            }
            case UiCheckedMenu: {
                SwingScilabCheckBoxMenuItem swingScilabCheckBoxMenuItem = new SwingScilabCheckBoxMenuItem(false);
                swingScilabCheckBoxMenuItem.setId(n);
                this.setMenuDefaultProperties(swingScilabCheckBoxMenuItem, n);
                return swingScilabCheckBoxMenuItem;
            }
            case UiContextMenu: {
                SwingScilabContextMenu swingScilabContextMenu = new SwingScilabContextMenu();
                swingScilabContextMenu.setId(n);
                return swingScilabContextMenu;
            }
            case Waitbar: {
                SwingScilabWaitBar swingScilabWaitBar = new SwingScilabWaitBar();
                swingScilabWaitBar.setIndeterminateMode(false);
                swingScilabWaitBar.setId(n);
                return swingScilabWaitBar;
            }
            case Tab: {
                SwingScilabTabGroup swingScilabTabGroup = new SwingScilabTabGroup();
                swingScilabTabGroup.setId(n);
                return swingScilabTabGroup;
            }
            case Layer: {
                SwingScilabLayer swingScilabLayer = new SwingScilabLayer();
                swingScilabLayer.setId(n);
                return swingScilabLayer;
            }
            case Browser: {
                SwingScilabBrowser swingScilabBrowser = new SwingScilabBrowser();
                swingScilabBrowser.setId(n);
                return swingScilabBrowser;
            }
        }
        System.err.println("[SwingView] Unmanaged Creation type !!!");
        return null;
    }

    private void setMenuDefaultProperties(Widget widget, Integer n) {
        SwingViewMenu.update(widget, 22, GraphicController.getController().getProperty(n, 22));
        SwingViewMenu.update(widget, 36, GraphicController.getController().getProperty(n, 36));
        SwingViewMenu.update(widget, 37, GraphicController.getController().getProperty(n, 37));
        SwingViewMenu.update(widget, 324, GraphicController.getController().getProperty(n, 324));
        SwingViewMenu.update(widget, 295, GraphicController.getController().getProperty(n, 295));
        SwingViewMenu.update(widget, 301, GraphicController.getController().getProperty(n, 301));
        SwingViewMenu.update(widget, 325, GraphicController.getController().getProperty(n, 325));
        SwingViewMenu.update(widget, 329, GraphicController.getController().getProperty(n, 329));
        SwingViewMenu.update(widget, 312, GraphicController.getController().getProperty(n, 312));
    }

    private void setDefaultProperties(SwingViewObject swingViewObject, Integer n) {
        swingViewObject.update(27, GraphicController.getController().getProperty(n, 27));
        swingViewObject.update(294, GraphicController.getController().getProperty(n, 294));
        swingViewObject.update(295, GraphicController.getController().getProperty(n, 295));
        swingViewObject.update(296, GraphicController.getController().getProperty(n, 296));
        swingViewObject.update(297, GraphicController.getController().getProperty(n, 297));
        swingViewObject.update(299, GraphicController.getController().getProperty(n, 299));
        swingViewObject.update(298, GraphicController.getController().getProperty(n, 298));
        swingViewObject.update(300, GraphicController.getController().getProperty(n, 300));
        swingViewObject.update(301, GraphicController.getController().getProperty(n, 301));
        swingViewObject.update(302, GraphicController.getController().getProperty(n, 302));
        swingViewObject.update(307, GraphicController.getController().getProperty(n, 307));
        swingViewObject.update(308, GraphicController.getController().getProperty(n, 308));
        swingViewObject.update(320, GraphicController.getController().getProperty(n, 320));
        swingViewObject.update(80, GraphicController.getController().getProperty(n, 80));
        swingViewObject.update(370, GraphicController.getController().getProperty(n, 370));
        swingViewObject.update(306, GraphicController.getController().getProperty(n, 306));
        swingViewObject.update(305, GraphicController.getController().getProperty(n, 305));
    }

    public void deleteObject(Integer n) {
        final TypedObject typedObject = this.allObjects.get(n);
        if (typedObject != null) {
            switch (typedObject.getType()) {
                case Figure: {
                    if (SwingUtilities.isEventDispatchThread()) {
                        SwingScilabPanel swingScilabPanel = (SwingScilabPanel)typedObject.getValue();
                        if (typedObject.getValue() instanceof SwingScilabDockablePanel) {
                            SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)swingScilabPanel;
                            swingScilabDockablePanel.disablePaint();
                            DockingManager.close((Dockable)swingScilabDockablePanel);
                            DockingManager.unregisterDockable((Dockable)swingScilabDockablePanel);
                            ClosingOperationsManager.unregisterClosingOperation(swingScilabDockablePanel);
                            ClosingOperationsManager.removeDependency(swingScilabDockablePanel);
                            ClosingOperationsManager.checkTabForClosing(swingScilabDockablePanel);
                            swingScilabPanel.close();
                        } else {
                            swingScilabPanel.close();
                        }
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SwingScilabPanel swingScilabPanel = (SwingScilabPanel)typedObject.getValue();
                                    if (swingScilabPanel instanceof SwingScilabDockablePanel) {
                                        SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)swingScilabPanel;
                                        swingScilabDockablePanel.disablePaint();
                                        DockingManager.close((Dockable)swingScilabDockablePanel);
                                        DockingManager.unregisterDockable((Dockable)swingScilabDockablePanel);
                                        ClosingOperationsManager.unregisterClosingOperation(swingScilabDockablePanel);
                                        ClosingOperationsManager.removeDependency(swingScilabDockablePanel);
                                        ClosingOperationsManager.checkTabForClosing(swingScilabDockablePanel);
                                        swingScilabPanel.close();
                                    } else {
                                        swingScilabPanel.close();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                    try {
                        Inspector.getInspector().close();
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case Progressbar: 
                case Waitbar: {
                    SwingScilabWaitBar swingScilabWaitBar = (SwingScilabWaitBar)typedObject.getValue();
                    swingScilabWaitBar.close();
                    break;
                }
                case Frame: {
                    Boolean bl = (Boolean)GraphicController.getController().getProperty(n, 403);
                    if (bl.booleanValue()) {
                        SwingScilabScrollableFrame swingScilabScrollableFrame = (SwingScilabScrollableFrame)typedObject.getValue();
                        swingScilabScrollableFrame.destroy();
                        break;
                    }
                    SwingScilabFrame swingScilabFrame = (SwingScilabFrame)typedObject.getValue();
                    swingScilabFrame.destroy();
                    break;
                }
                case UiContextMenu: {
                    SwingScilabContextMenu swingScilabContextMenu = (SwingScilabContextMenu)typedObject.getValue();
                    swingScilabContextMenu.destroy();
                    break;
                }
            }
            this.allObjects.remove(n);
        }
    }

    public void updateObject(final Integer n, final int n2) {
        Object object;
        int n3;
        final TypedObject typedObject = this.allObjects.get(n);
        if (n2 == 81 && (headless || GraphicsEnvironment.isHeadless()) && (n3 = ((Integer)GraphicController.getController().getProperty(n, 29)).intValue()) == 8) {
            object = (Integer[])GraphicController.getController().getProperty(n, 81);
            GraphicController.getController().setProperty(n, 85, object);
        }
        if (typedObject != null && n2 == 79 && ((Boolean)GraphicController.getController().getProperty(n, 79)).booleanValue() && typedObject.getValue() instanceof SwingScilabDockablePanel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean bl = (Boolean)GraphicController.getController().getProperty(n, 27);
                    ((SwingScilabDockablePanel)typedObject.getValue()).getParentWindow().setVisible(bl);
                    ((SwingScilabDockablePanel)typedObject.getValue()).setVisible(true);
                    Integer[] integerArray = (Integer[])GraphicController.getController().getProperty(n, 81);
                    ((SwingScilabDockablePanel)typedObject.getValue()).getParentWindow().setDims(new Size(integerArray[0], integerArray[1]));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        if (n2 == 95) {
            return;
        }
        if (typedObject == null && n2 != 279) {
            return;
        }
        if (typedObject == null && n2 == 279) {
            n3 = (Integer)GraphicController.getController().getProperty(n, 279);
            this.allObjects.put(n, this.CreateObjectFromType(n3, n));
            return;
        }
        if (n2 == 411) {
            this.requestFocus(typedObject);
            return;
        }
        n3 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n3 == 1) {
            if (n2 == 24) {
                object = (Integer)GraphicController.getController().getProperty(n, 24);
                TypedObject typedObject2 = this.allObjects.get(object);
                if (typedObject2 == null) {
                    this.allObjects.remove(n);
                } else {
                    ((SwingScilabAxes)this.allObjects.get(n).getValue()).update(n2, object);
                }
            }
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateObjectOnEDT(typedObject, n, n2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingView.this.updateObjectOnEDT(typedObject, n, n2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void updateObjectOnEDT(TypedObject typedObject, Integer n, int n2) {
        Component component;
        int n3;
        int n4;
        Object object;
        block31: {
            Integer n5;
            if (typedObject != null && n2 == 24 && (object = this.allObjects.get(n5 = (Integer)GraphicController.getController().getProperty(n, 24))) == null) {
                this.allObjects.remove(n);
            }
            n4 = (Integer)GraphicController.getController().getProperty(n, 29);
            if (typedObject == null || n2 != 22) break block31;
            object = (Integer[])GraphicController.getController().getProperty(n, 22);
            block0 : switch (n4) {
                case 8: {
                    this.updateFigureChildren(typedObject, (Integer[])object);
                    break;
                }
                case 330: {
                    this.updateConsoleChildren(typedObject, (Integer[])object);
                    break;
                }
                case 20: {
                    this.updateMenuChildren(typedObject, n, (Integer[])object);
                    break;
                }
                case 21: {
                    this.updateContextMenuChildren(typedObject, (Integer[])object);
                    break;
                }
                case 19: {
                    n3 = (Integer)GraphicController.getController().getProperty(n, 279);
                    switch (n3) {
                        case 293: {
                            this.updateLayerChildren(typedObject, (Integer[])object);
                            break block0;
                        }
                        case 283: {
                            if (typedObject.getValue() instanceof SwingScilabFrame) {
                                this.updateFrameChildren(typedObject, (Integer[])object);
                                break block0;
                            }
                            if (typedObject.getValue() instanceof SwingScilabScrollableFrame) {
                                this.updateScrollableFrameChildren(typedObject, (Integer[])object);
                                break block0;
                            }
                            break block31;
                        }
                        case 372: {
                            this.updateTabGroupChildren(typedObject, (Integer[])object);
                        }
                    }
                }
            }
        }
        if (typedObject != null && n2 == 324 && n4 == 20) {
            switch (typedObject.getType()) {
                case UiParentMenu: {
                    object = (SwingScilabMenu)typedObject.getValue();
                    Container container = ((Component)object).getParent();
                    if (container != null) {
                        container.remove((Component)object);
                    }
                    typedObject = this.CreateObjectFromType(323, n);
                    this.allObjects.put(n, typedObject);
                    component = (SwingScilabCheckBoxMenuItem)typedObject.getValue();
                    if (container == null) break;
                    container.add(component);
                    break;
                }
                case UiChildMenu: {
                    object = (SwingScilabMenuItem)this.allObjects.get(n).getValue();
                    JComponent jComponent = (JComponent)((Component)object).getParent();
                    int n6 = 0;
                    if (jComponent != null) {
                        n6 = jComponent.getComponentZOrder((Component)object);
                        jComponent.remove((Component)object);
                    }
                    typedObject = this.CreateObjectFromType(323, n);
                    this.allObjects.put(n, typedObject);
                    typedObject = this.allObjects.get(n);
                    if (jComponent != null) {
                        jComponent.add((Component)((SwingScilabCheckBoxMenuItem)typedObject.getValue()), n6);
                    }
                    return;
                }
            }
        }
        if (typedObject != null && n2 == 328 && n4 == 20) {
            int n7;
            object = (Integer)GraphicController.getController().getProperty(n, 24);
            n3 = -1;
            component = (Component)((Object)typedObject.getValue());
            Component[] componentArray = ((SwingScilabMenu)this.allObjects.get(object).getValue()).getMenuComponents();
            for (n7 = 0; n7 < componentArray.length; ++n7) {
                if (componentArray[n7] != component) continue;
                n3 = n7;
                break;
            }
            if (n3 < 0) {
                return;
            }
            n7 = ((Boolean)GraphicController.getController().getProperty(n, 328)).booleanValue() ? 1 : 0;
            if (n7 != 0) {
                ((SwingScilabMenu)this.allObjects.get(object).getValue()).insertSeparator(n3);
            } else {
                if (n3 == 0) {
                    return;
                }
                if (((SwingScilabMenu)this.allObjects.get(object).getValue()).getComponent(n3 - 1) instanceof JSeparator) {
                    ((SwingScilabMenu)this.allObjects.get(object).getValue()).remove(n3 - 1);
                }
            }
        }
        if (typedObject != null && (object = typedObject.getValue()) != null) {
            object.update(n2, GraphicController.getController().getProperty(n, n2));
        }
    }

    private void updateFigureChildren(TypedObject typedObject, Integer[] integerArray) {
        Integer[] integerArray2;
        Container container = (Container)((Object)typedObject.getValue());
        boolean bl = false;
        boolean bl2 = false;
        for (Integer n : integerArray) {
            if (typedObject.hasChild(n)) continue;
            typedObject.addChild(n);
            int n2 = (Integer)GraphicController.getController().getProperty(n, 29);
            if (n2 == 1) {
                SwingViewObject swingViewObject = this.allObjects.get(n).getValue();
                ((SwingScilabPanel)((Object)container)).addMember(swingViewObject);
            }
            if (n2 == 19) {
                SwingViewObject swingViewObject = this.allObjects.get(n).getValue();
                ((SwingScilabPanel)((Object)container)).addMember(swingViewObject);
                swingViewObject.update(80, GraphicController.getController().getProperty(n, 80));
                bl = true;
            }
            if (n2 != 20) continue;
            TypedObject typedObject2 = this.allObjects.get(n);
            switch (typedObject2.getType()) {
                case UiChildMenu: 
                case UiCheckedMenu: {
                    this.allObjects.remove(n);
                    this.allObjects.put(n, this.CreateObjectFromType(321, n));
                    ((Container)((Object)((SwingScilabPanel)((Object)container)).getMenuBar().getAsSimpleMenuBar())).add((SwingScilabMenu)this.allObjects.get(n).getValue());
                    break;
                }
                default: {
                    ((Container)((Object)((SwingScilabPanel)((Object)container)).getMenuBar().getAsSimpleMenuBar())).add((SwingScilabMenu)this.allObjects.get(n).getValue());
                }
            }
            bl2 = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        for (Integer n : integerArray2 = typedObject.getChildren().toArray(new Integer[typedObject.getChildren().size()])) {
            if (hashSet.contains(n)) continue;
            typedObject.removeChild(n);
            Object object = GraphicController.getController().getProperty(n, 29);
            if (object == null) continue;
            int n2 = (Integer)object;
            if (n2 == 19) {
                ((SwingScilabPanel)((Object)container)).removeMember(this.allObjects.get(n).getValue());
                bl = true;
            }
            if (n2 != 20) continue;
            TypedObject typedObject3 = this.allObjects.get(n);
            switch (typedObject3.getType()) {
                case UiCheckedMenu: {
                    ((Container)((Object)((SwingScilabPanel)((Object)container)).getMenuBar().getAsSimpleMenuBar())).remove((SwingScilabCheckBoxMenuItem)this.allObjects.get(n).getValue());
                    break;
                }
                default: {
                    ((Container)((Object)((SwingScilabPanel)((Object)container)).getMenuBar().getAsSimpleMenuBar())).remove((SwingScilabMenu)this.allObjects.get(n).getValue());
                }
            }
            bl2 = true;
        }
        if (bl2) {
            ((JComponent)((Object)((SwingScilabPanel)((Object)container)).getMenuBar().getAsSimpleMenuBar())).revalidate();
            ((JComponent)((Object)((SwingScilabPanel)((Object)container)).getMenuBar().getAsSimpleMenuBar())).repaint();
        }
        if (bl && container != null) {
            ((JComponent)container).revalidate();
        }
    }

    private void updateFrameChildren(TypedObject typedObject, Integer[] integerArray) {
        Integer[] integerArray2;
        SwingScilabFrame swingScilabFrame = (SwingScilabFrame)typedObject.getValue();
        boolean bl = false;
        boolean bl2 = false;
        int n = swingScilabFrame.getComponentCount();
        for (Integer n2 : integerArray) {
            int n3 = (Integer)GraphicController.getController().getProperty(n2, 29);
            if (!typedObject.hasChild(n2)) {
                typedObject.addChild(n2);
                if (n3 == 19 || n3 == 1) {
                    swingScilabFrame.addMember(this.allObjects.get(n2).getValue());
                    bl = true;
                }
            }
            if (n3 != 1) continue;
            bl2 = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        for (Integer n4 : integerArray2 = typedObject.getChildren().toArray(new Integer[typedObject.getChildren().size()])) {
            if (hashSet.contains(n4)) continue;
            typedObject.removeChild(n4);
            int n5 = (Integer)GraphicController.getController().getProperty(n4, 29);
            if (n5 != 19) continue;
            swingScilabFrame.remove((Component)((Object)this.allObjects.get(n4).getValue()));
            bl = true;
        }
        if (!bl2) {
            swingScilabFrame.removeAxes();
            bl = true;
        }
        if (bl && swingScilabFrame != null) {
            swingScilabFrame.revalidate();
        }
        if (n > swingScilabFrame.getComponentCount()) {
            swingScilabFrame.repaint();
        }
    }

    private void updateScrollableFrameChildren(TypedObject typedObject, Integer[] integerArray) {
        Integer[] integerArray2;
        SwingScilabScrollableFrame swingScilabScrollableFrame = (SwingScilabScrollableFrame)typedObject.getValue();
        boolean bl = false;
        int n = swingScilabScrollableFrame.getPanel().getComponentCount();
        for (Integer n2 : integerArray) {
            if (typedObject.hasChild(n2)) continue;
            typedObject.addChild(n2);
            int n3 = (Integer)GraphicController.getController().getProperty(n2, 29);
            if (n3 != 19) continue;
            swingScilabScrollableFrame.addMember(this.allObjects.get(n2).getValue());
            bl = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        for (Integer n4 : integerArray2 = typedObject.getChildren().toArray(new Integer[typedObject.getChildren().size()])) {
            if (hashSet.contains(n4)) continue;
            typedObject.removeChild(n4);
            int n5 = (Integer)GraphicController.getController().getProperty(n4, 29);
            if (n5 != 19) continue;
            swingScilabScrollableFrame.getPanel().remove((Component)((Object)this.allObjects.get(n4).getValue()));
            bl = true;
        }
        if (bl && swingScilabScrollableFrame != null) {
            swingScilabScrollableFrame.getPanel().revalidate();
        }
        if (n > swingScilabScrollableFrame.getPanel().getComponentCount()) {
            swingScilabScrollableFrame.repaint();
        }
    }

    private void updateLayerChildren(TypedObject typedObject, Integer[] integerArray) {
        Integer[] integerArray2;
        SwingScilabLayer swingScilabLayer = (SwingScilabLayer)typedObject.getValue();
        for (Integer n : integerArray) {
            int n2;
            if (typedObject.hasChild(n)) continue;
            typedObject.addChild(n);
            int n3 = (Integer)GraphicController.getController().getProperty(n, 29);
            if (n3 != 19 || (n2 = ((Integer)GraphicController.getController().getProperty(n, 279)).intValue()) != 283) continue;
            SwingViewObject swingViewObject = this.allObjects.get(n).getValue();
            if (swingViewObject instanceof SwingScilabScrollableFrame) {
                swingScilabLayer.addMember((SwingScilabScrollableFrame)swingViewObject);
                continue;
            }
            swingScilabLayer.addMember((SwingScilabFrame)swingViewObject);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        for (Integer n : integerArray2 = typedObject.getChildren().toArray(new Integer[typedObject.getChildren().size()])) {
            int n4;
            if (hashSet.contains(n)) continue;
            typedObject.removeChild(n);
            int n5 = (Integer)GraphicController.getController().getProperty(n, 29);
            if (n5 != 19 || (n4 = ((Integer)GraphicController.getController().getProperty(n, 279)).intValue()) != 283) continue;
            SwingViewObject swingViewObject = this.allObjects.get(n).getValue();
            if (swingViewObject instanceof SwingScilabScrollableFrame) {
                swingScilabLayer.removeMember((SwingScilabScrollableFrame)swingViewObject);
                continue;
            }
            swingScilabLayer.removeMember((SwingScilabFrame)swingViewObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateTabGroupChildren(TypedObject typedObject, Integer[] integerArray) {
        Integer[] integerArray2;
        SwingScilabTabGroup swingScilabTabGroup = (SwingScilabTabGroup)typedObject.getValue();
        boolean bl = false;
        for (Integer n : integerArray) {
            void object;
            if (typedObject.hasChild(n)) continue;
            typedObject.addChild(n);
            int n2 = (Integer)GraphicController.getController().getProperty(n, 29);
            if (n2 != 19) continue;
            String string = "Tab";
            String[] stringArray = (String[])GraphicController.getController().getProperty(n, 308);
            if (stringArray != null && stringArray.length != 0 && stringArray[0] != null) {
                String string2 = stringArray[0];
            }
            swingScilabTabGroup.insertTab((String)object, null, (Component)((Object)this.allObjects.get(n).getValue()), "", 0);
            bl = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        for (Integer n : integerArray2 = typedObject.getChildren().toArray(new Integer[typedObject.getChildren().size()])) {
            if (hashSet.contains(n)) continue;
            typedObject.removeChild(n);
            int n2 = (Integer)GraphicController.getController().getProperty(n, 29);
            if (n2 != 19) continue;
            swingScilabTabGroup.remove((Component)((Object)this.allObjects.get(n).getValue()));
            bl = true;
        }
        if (bl && swingScilabTabGroup != null) {
            swingScilabTabGroup.revalidate();
        }
    }

    private void updateConsoleChildren(TypedObject typedObject, Integer[] integerArray) {
        int n;
        SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)typedObject.getValue();
        boolean bl = false;
        for (Integer n2 : integerArray) {
            if (typedObject.hasChild(n2)) continue;
            typedObject.addChild(n2);
            n = (Integer)GraphicController.getController().getProperty(n2, 29);
            if (n != 20) continue;
            TypedObject typedObject2 = this.allObjects.get(n2);
            switch (typedObject2.getType()) {
                case UiChildMenu: 
                case UiCheckedMenu: {
                    TypedObject typedObject3 = this.CreateObjectFromType(321, n2);
                    this.allObjects.put(n2, typedObject3);
                    ((Container)((Object)((SwingScilabDockablePanel)typedObject.getValue()).getMenuBar().getAsSimpleMenuBar())).add((SwingScilabMenu)typedObject3.getValue());
                    break;
                }
                default: {
                    ((Container)((Object)((SwingScilabDockablePanel)typedObject.getValue()).getMenuBar().getAsSimpleMenuBar())).add((SwingScilabMenu)typedObject2.getValue());
                }
            }
            bl = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        Object[] objectArray = typedObject.getChildren().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n2;
            n2 = (Integer)objectArray[i];
            if (hashSet.contains(n2)) continue;
            typedObject.removeChild(n2);
            n = (Integer)GraphicController.getController().getProperty(n2, 29);
            if (n != 20) continue;
            ((Container)((Object)((SwingScilabDockablePanel)typedObject.getValue()).getMenuBar().getAsSimpleMenuBar())).remove((SwingScilabMenu)this.allObjects.get(n2).getValue());
            bl = true;
        }
        if (bl && swingScilabDockablePanel != null) {
            ((Container)((Object)swingScilabDockablePanel)).validate();
        }
    }

    private void updateMenuChildren(TypedObject typedObject, Integer n, Integer[] integerArray) {
        Object object;
        Container container = null;
        boolean bl = false;
        int n2 = 0;
        TypedObject typedObject2 = null;
        for (Integer n3 : integerArray) {
            int n4 = (Integer)GraphicController.getController().getProperty(n3, 29);
            if (n4 != 20 || typedObject.hasChild(n3)) continue;
            typedObject.addChild(n3);
            object = this.allObjects.get(n3);
            SwingViewObject swingViewObject = this.allObjects.get(n3).getValue();
            JComponent jComponent = null;
            block0 : switch (typedObject.getType()) {
                case UiChildMenu: {
                    container = (SwingScilabMenuItem)typedObject.getValue();
                    jComponent = (JComponent)container.getParent();
                    switch (((TypedObject)object).getType()) {
                        case UiChildMenu: {
                            if (jComponent != null) {
                                n2 = jComponent.getComponentZOrder((SwingScilabMenuItem)typedObject.getValue());
                                jComponent.remove((SwingScilabMenuItem)typedObject.getValue());
                            }
                            typedObject2 = this.CreateObjectFromType(321, n);
                            this.allObjects.put(n, typedObject2);
                            typedObject2.addChild(n3);
                            if (jComponent != null) {
                                jComponent.add((Component)((SwingScilabMenu)typedObject2.getValue()), n2);
                            }
                            ((SwingScilabMenu)typedObject2.getValue()).add((SwingScilabMenuItem)swingViewObject);
                            break block0;
                        }
                        case UiCheckedMenu: {
                            if (jComponent != null) {
                                n2 = jComponent.getComponentZOrder((SwingScilabCheckBoxMenuItem)typedObject.getValue());
                                jComponent.remove((SwingScilabCheckBoxMenuItem)typedObject.getValue());
                            }
                            typedObject2 = this.CreateObjectFromType(321, n);
                            this.allObjects.put(n, typedObject2);
                            typedObject2.addChild(n3);
                            if (jComponent != null) {
                                jComponent.add((Component)((SwingScilabMenu)typedObject2.getValue()), n2);
                            }
                            ((SwingScilabMenu)typedObject2.getValue()).add((SwingScilabCheckBoxMenuItem)swingViewObject);
                            break block0;
                        }
                    }
                    ((SwingScilabMenu)typedObject.getValue()).add((SwingScilabMenu)swingViewObject);
                    break;
                }
                case UiCheckedMenu: {
                    container = (SwingScilabCheckBoxMenuItem)typedObject.getValue();
                    jComponent = (JComponent)container.getParent();
                    switch (((TypedObject)object).getType()) {
                        case UiChildMenu: {
                            if (jComponent != null) {
                                n2 = jComponent.getComponentZOrder((SwingScilabCheckBoxMenuItem)typedObject.getValue());
                                jComponent.remove((SwingScilabCheckBoxMenuItem)this.allObjects.get(n).getValue());
                            }
                            typedObject2 = this.CreateObjectFromType(321, n);
                            this.allObjects.put(n, typedObject2);
                            typedObject2.addChild(n3);
                            if (jComponent != null) {
                                jComponent.add((Component)((SwingScilabMenu)typedObject2.getValue()), n2);
                            }
                            ((SwingScilabMenu)typedObject2.getValue()).add((SwingScilabMenuItem)this.allObjects.get(n3).getValue());
                            break block0;
                        }
                        case UiCheckedMenu: {
                            if (jComponent != null) {
                                n2 = jComponent.getComponentZOrder((SwingScilabCheckBoxMenuItem)typedObject.getValue());
                                jComponent.remove((SwingScilabCheckBoxMenuItem)this.allObjects.get(n).getValue());
                            }
                            typedObject2 = this.CreateObjectFromType(321, n);
                            this.allObjects.put(n, typedObject2);
                            typedObject2.addChild(n3);
                            if (jComponent != null) {
                                jComponent.add((Component)((SwingScilabMenu)typedObject2.getValue()), n2);
                            }
                            ((SwingScilabMenu)typedObject2.getValue()).add((SwingScilabCheckBoxMenuItem)this.allObjects.get(n3).getValue());
                            break block0;
                        }
                    }
                    ((SwingScilabMenu)typedObject.getValue()).add((SwingScilabMenu)this.allObjects.get(n3).getValue());
                    break;
                }
                default: {
                    SwingScilabMenu swingScilabMenu = (SwingScilabMenu)typedObject.getValue();
                    container = swingScilabMenu;
                    switch (((TypedObject)object).getType()) {
                        case UiChildMenu: {
                            swingScilabMenu.add((SwingScilabMenuItem)this.allObjects.get(n3).getValue());
                            break block0;
                        }
                        case UiCheckedMenu: {
                            swingScilabMenu.add((SwingScilabCheckBoxMenuItem)this.allObjects.get(n3).getValue());
                            break block0;
                        }
                    }
                    TypedObject typedObject3 = this.CreateObjectFromType(20, n3);
                    this.allObjects.put(n3, typedObject3);
                    swingScilabMenu.add((SwingScilabMenuItem)typedObject3.getValue());
                }
            }
            bl = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        Integer[] integerArray2 = typedObject.getChildren().toArray(new Integer[typedObject.getChildren().size()]);
        for (int i = 0; i < integerArray2.length; ++i) {
            Integer n3;
            n3 = integerArray2[i];
            if (hashSet.contains(n3)) continue;
            typedObject.removeChild(n3);
            container = (SwingScilabMenu)typedObject.getValue();
            TypedObject typedObject4 = this.allObjects.get(n3);
            object = typedObject4.getValue();
            switch (typedObject4.getType()) {
                case UiChildMenu: {
                    container.remove((SwingScilabMenuItem)object);
                    break;
                }
                case UiCheckedMenu: {
                    container.remove((SwingScilabCheckBoxMenuItem)object);
                    break;
                }
                default: {
                    container.remove((SwingScilabMenu)object);
                }
            }
            bl = true;
        }
        if (bl && container != null) {
            container.validate();
        }
    }

    private void updateContextMenuChildren(TypedObject typedObject, Integer[] integerArray) {
        Object object;
        Container container = null;
        boolean bl = false;
        for (Integer object2 : integerArray) {
            int n = (Integer)GraphicController.getController().getProperty(object2, 29);
            if (n != 20 || typedObject.hasChild(object2)) continue;
            typedObject.addChild(object2);
            object = this.allObjects.get(object2);
            SwingScilabContextMenu swingScilabContextMenu = (SwingScilabContextMenu)typedObject.getValue();
            container = swingScilabContextMenu;
            switch (((TypedObject)object).getType()) {
                case UiChildMenu: {
                    swingScilabContextMenu.add((SwingScilabMenuItem)this.allObjects.get(object2).getValue());
                    break;
                }
                case UiCheckedMenu: {
                    swingScilabContextMenu.add((SwingScilabCheckBoxMenuItem)this.allObjects.get(object2).getValue());
                    break;
                }
                default: {
                    swingScilabContextMenu.add((SwingScilabMenu)this.allObjects.get(object2).getValue());
                }
            }
            bl = true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        for (Integer n : typedObject.getChildren()) {
            if (hashSet.contains(n)) continue;
            typedObject.removeChild(n);
            container = (SwingScilabMenu)typedObject.getValue();
            TypedObject typedObject2 = this.allObjects.get(n);
            SwingScilabContextMenu swingScilabContextMenu = (SwingScilabContextMenu)typedObject.getValue();
            object = this.allObjects.get(n).getValue();
            switch (typedObject2.getType()) {
                case UiChildMenu: {
                    swingScilabContextMenu.remove((SwingScilabMenuItem)object);
                    break;
                }
                case UiCheckedMenu: {
                    swingScilabContextMenu.remove((SwingScilabCheckBoxMenuItem)object);
                    break;
                }
                default: {
                    swingScilabContextMenu.remove((SwingScilabMenu)object);
                }
            }
            bl = true;
        }
        if (bl && container != null) {
            container.validate();
        }
    }

    private void requestFocus(TypedObject typedObject) {
        SwingViewObject swingViewObject = typedObject.getValue();
        if (swingViewObject instanceof SwingScilabScrollableFrame) {
            ((SwingScilabScrollableFrame)swingViewObject).requestFocus();
        } else if (swingViewObject instanceof SwingScilabFrame) {
            ((SwingScilabFrame)swingViewObject).requestFocus();
        } else {
            ((Widget)((Object)swingViewObject)).requestFocus();
        }
    }

    static {
        try {
            System.loadLibrary("gluegen_rt");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        managedTypes = new HashSet<Integer>(Arrays.asList(8, 1, 21, 20, 330, 335, 334, 19));
    }

    private static class TypedObject {
        private UielementType _type;
        private SwingViewObject _value;
        private Set<Integer> _children;

        public TypedObject(UielementType uielementType, SwingViewObject swingViewObject) {
            this._type = uielementType;
            this._value = swingViewObject;
            this._children = Collections.synchronizedSet(new HashSet());
        }

        public UielementType getType() {
            return this._type;
        }

        public SwingViewObject getValue() {
            return this._value;
        }

        public Set<Integer> getChildren() {
            return this._children;
        }

        public void addChild(Integer n) {
            this._children.add(n);
        }

        public void removeChild(Integer n) {
            this._children.remove(n);
        }

        public boolean hasChild(Integer n) {
            return this._children.contains(n);
        }
    }

    private static enum UielementType {
        Console,
        CheckBox,
        Edit,
        Spinner,
        Frame,
        Figure,
        Axes,
        Image,
        ListBox,
        PopupMenu,
        Progressbar,
        PushButton,
        RadioButton,
        Slider,
        Table,
        Text,
        Uimenu,
        UiParentMenu,
        UiChildMenu,
        UiCheckedMenu,
        UiContextMenu,
        Waitbar,
        Tab,
        Layer,
        Browser;

    }
}

