/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import java.util.Set;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.console.ConsoleOptions;
import org.scilab.modules.console.SciConsole;
import org.scilab.modules.console.utils.ScilabLaTeXViewer;

public class ConsoleConfiguration
implements XConfigurationListener {
    private SciConsole sciConsole;

    public ConsoleConfiguration(SciConsole sciConsole) {
        this.sciConsole = sciConsole;
    }

    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        Conf conf = new Conf(xConfigurationEvent.getModifiedPaths());
        if (conf.changed()) {
            ConsoleOptions.invalidate(conf);
            this.sciConsole.configurationChanged(conf);
            ScilabLaTeXViewer.configurationChanged(conf);
        }
    }

    public static class Conf {
        public boolean latex;
        public boolean font;
        public boolean color;
        public boolean display;
        public boolean keymap;

        public Conf(Set<String> set) {
            if (set.contains("ALL")) {
                this.font = true;
                this.color = true;
                this.display = true;
                this.keymap = true;
                this.latex = true;
            } else {
                this.latex = set.contains("//fonts/body/fonts");
                this.font = set.contains("//fonts/body/fonts/item[@xconf-uid=\"console-font\"]") || set.contains("//fonts/body/fonts");
                this.color = set.contains("//colors/body/desktop-colors");
                this.display = set.contains("//console/body/display");
                this.keymap = set.contains("//general/shortcuts/body/actions/action-folder[@xconf-uid=\"console\"]/action");
            }
        }

        public boolean changed() {
            return this.font || this.color || this.display || this.keymap || this.latex;
        }
    }
}

