/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.ui;

import com.artenum.rosetta.interfaces.core.CompletionItem;
import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.CompletionWindow;
import com.artenum.rosetta.ui.CompletionItemListCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class CompletionWindowImpl
implements CompletionWindow,
KeyListener,
FocusListener,
MouseMotionListener,
MouseListener {
    private CompletionItemListModel model;
    private JList listUI;
    private JScrollPane scrollPane;
    private JWindow window;
    private InputParsingManager inputParsingManager;
    private JComponent focusOutComponent;

    public void setFocusOut(JComponent component) {
        this.focusOutComponent = component;
    }

    public void setInputParsingManager(InputParsingManager inputParsingManager) {
        this.inputParsingManager = inputParsingManager;
    }

    public void setGraphicalContext(Component component) {
        this.window = component instanceof Frame ? new JWindow((Frame)component) : new JWindow(SwingUtilities.getWindowAncestor(component));
        this.model = new CompletionItemListModel();
        this.listUI = new JList(this.model);
        this.listUI.setCellRenderer(new CompletionItemListCellRenderer());
        this.scrollPane = new JScrollPane(this.listUI, 20, 30);
        JLabel windowResizeCorner = new JLabel("~", 0);
        windowResizeCorner.addMouseMotionListener(this);
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", windowResizeCorner);
        this.window.getContentPane().add(this.scrollPane);
        this.window.setSize(new Dimension(300, 100));
        this.listUI.getInputMap().clear();
        this.scrollPane.getInputMap().clear();
        this.listUI.addKeyListener(this);
        this.listUI.addFocusListener(this);
    }

    public void show(List<CompletionItem> list, Point location) {
        this.model.updateData(list);
        this.window.setLocation(location);
        this.window.setVisible(true);
        if (this.model.getSize() > 0) {
            this.listUI.setSelectedIndex(0);
        }
    }

    public String getCompletionResult() {
        return ((CompletionItem)this.listUI.getSelectedValue()).getReturnValue();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.inputParsingManager.writeCompletionPart(((CompletionItem)this.listUI.getSelectedValue()).getReturnValue());
            this.window.setVisible(false);
            this.focusOutComponent.grabFocus();
        } else if (e.getKeyCode() != 32) {
            if (e.getKeyCode() == 27) {
                this.window.setVisible(false);
                this.focusOutComponent.grabFocus();
            } else if (e.getKeyCode() == 40) {
                if (this.model.getSize() > 0) {
                    this.listUI.setSelectedIndex(this.listUI.getSelectedIndex() % this.model.getSize());
                }
            } else if (e.getKeyCode() == 38) {
                if (this.model.getSize() > 0) {
                    this.listUI.setSelectedIndex((this.model.getSize() + this.listUI.getSelectedIndex()) % this.model.getSize());
                }
            } else if (e.getKeyCode() == 8) {
                if (this.inputParsingManager.getPartLevel(this.inputParsingManager.getCompletionLevel()).length() > 0) {
                    this.inputParsingManager.backspace();
                    this.model.setFilter(this.inputParsingManager.getPartLevel(this.inputParsingManager.getCompletionLevel()));
                    this.listUI.setSelectedIndex(0);
                } else {
                    this.window.setVisible(false);
                    this.focusOutComponent.grabFocus();
                }
            } else if (e.getKeyChar() != '\uffff') {
                this.inputParsingManager.append(String.valueOf(e.getKeyChar()));
                this.model.setFilter(this.inputParsingManager.getPartLevel(this.inputParsingManager.getCompletionLevel()));
                this.listUI.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.window.setVisible(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point origine = this.window.getLocationOnScreen();
        Point destination = ((Component)e.getSource()).getLocationOnScreen();
        destination.x += e.getX();
        destination.y += e.getY();
        destination.translate(-origine.x, -origine.y);
        this.window.setSize(destination.x, destination.y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.window.validate();
    }

    public class CompletionItemListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private final ArrayList<CompletionItem> data = new ArrayList();
        private final ArrayList<CompletionItem> filteredData = new ArrayList();
        private String filter;

        @Override
        public Object getElementAt(int index) {
            return this.filter != null ? this.filteredData.get(index) : this.data.get(index);
        }

        @Override
        public int getSize() {
            return this.filter != null ? this.filteredData.size() : this.data.size();
        }

        public void setFilter(String filter) {
            if (filter == null || filter != null && filter.length() == 0) {
                this.filter = null;
            } else {
                this.filter = filter;
                this.filteredData.clear();
                for (CompletionItem item : this.data) {
                    if (!item.getReturnValue().toLowerCase().startsWith(filter.toLowerCase())) continue;
                    this.filteredData.add(item);
                }
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void updateData(List<CompletionItem> list) {
            this.data.clear();
            this.data.addAll(list);
            Collections.sort(this.data);
            this.setFilter(null);
        }
    }
}

