/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.core;

import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.InputCommandView;
import java.awt.Point;

public class DefaultInputParsingManager
implements InputParsingManager {
    private InputCommandView inputCommandView;
    private Point windowCompletionPosition = new Point(0, 0);

    public void append(String content) {
        this.inputCommandView.append(content);
    }

    public int getCaretPosition() {
        return this.inputCommandView.getCaretPosition();
    }

    public String getCommandLine() {
        return this.inputCommandView.getText();
    }

    public int getCompletionLevel() {
        return 0;
    }

    public int getNumberOfLines() {
        int result = this.inputCommandView.getText().split("\n").length;
        if (this.inputCommandView.getText().lastIndexOf("\n") != -1) {
            ++result;
        }
        return result;
    }

    public String getPartLevel(int level) {
        if (level == 0) {
            return this.getCommandLine();
        }
        return null;
    }

    public Point getWindowCompletionLocation() {
        this.windowCompletionPosition.setLocation(this.inputCommandView.getCaretLocation());
        this.windowCompletionPosition.translate(4, 2);
        return this.windowCompletionPosition;
    }

    public boolean isBlockEditing() {
        return false;
    }

    public void reset() {
        this.inputCommandView.reset();
    }

    public void setInputCommandView(InputCommandView inputCommandView) {
        this.inputCommandView = inputCommandView;
    }

    public void writeCompletionPart(String completionResult) {
        this.inputCommandView.append(completionResult);
    }

    public void backspace() {
        this.inputCommandView.backspace();
    }
}

