/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.io;

import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxCodecRegistry;
import java.util.Map;
import java.util.logging.Logger;
import org.scilab.modules.graph.io.ScilabObjectCodec;
import org.scilab.modules.types.ScilabDouble;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ScilabDoubleCodec
extends ScilabObjectCodec {
    private static final String REALPART = "realPart";
    private static final String IMGPART = "imaginaryPart";

    public ScilabDoubleCodec(Object object, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        super(object, stringArray, stringArray2, map);
    }

    public Node encode(mxCodec mxCodec2, Object object) {
        String string = mxCodecRegistry.getName((Object)object);
        Element element = mxCodec2.getDocument().createElement(string);
        ScilabDouble scilabDouble = (ScilabDouble)object;
        if (binary) {
            int n = binaryObjects.size();
            binaryObjects.add((Object)scilabDouble);
            mxCodec.setAttribute((Node)element, (String)"binary", (Object)"true");
            mxCodec.setAttribute((Node)element, (String)"position", (Object)n);
            return element;
        }
        mxCodec.setAttribute((Node)element, (String)"width", (Object)scilabDouble.getWidth());
        mxCodec.setAttribute((Node)element, (String)"height", (Object)scilabDouble.getHeight());
        for (int i = 0; i < scilabDouble.getHeight(); ++i) {
            for (int j = 0; j < scilabDouble.getWidth(); ++j) {
                double[][] dArray;
                Element element2 = mxCodec2.getDocument().createElement("data");
                mxCodec.setAttribute((Node)element2, (String)"line", (Object)i);
                mxCodec.setAttribute((Node)element2, (String)"column", (Object)j);
                if (scilabDouble.getRealPart() != null) {
                    mxCodec.setAttribute((Node)element2, (String)REALPART, (Object)scilabDouble.getRealPart()[i][j]);
                }
                if (scilabDouble.getImaginaryPart() != null && (dArray = scilabDouble.getImaginaryPart()).length > i && dArray[i].length > j) {
                    mxCodec.setAttribute((Node)element2, (String)IMGPART, (Object)dArray[i][j]);
                }
                element.appendChild(element2);
            }
        }
        return element;
    }

    public Object decode(mxCodec mxCodec2, Node node, Object object) {
        ScilabDouble scilabDouble = null;
        try {
            int n;
            if (node.getNodeType() != 1) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            if (this.getBooleanAttribute(namedNodeMap, "binary")) {
                return binaryObjects.get(this.getIntegerAttribute(namedNodeMap, "position"));
            }
            scilabDouble = (ScilabDouble)this.cloneTemplate(node);
            int n2 = this.getHeight(namedNodeMap);
            if (n2 * (n = this.getWidth(namedNodeMap)) == 0) {
                return scilabDouble;
            }
            double[][] dArray = new double[n2][n];
            double[][] dArray2 = new double[n2][n];
            boolean bl = this.fillData(node, dArray, dArray2);
            scilabDouble.setRealPart(dArray);
            if (!bl) {
                scilabDouble.setImaginaryPart(dArray2);
            }
        }
        catch (ScilabObjectCodec.UnrecognizeFormatException unrecognizeFormatException) {
            Logger.getLogger(ScilabDoubleCodec.class.getName()).severe(unrecognizeFormatException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(ScilabDoubleCodec.class.getName()).severe(numberFormatException.toString());
        }
        return scilabDouble;
    }

    private boolean fillData(Node node, double[][] dArray, double[][] dArray2) throws ScilabObjectCodec.UnrecognizeFormatException {
        boolean bl = true;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            int n = this.getColumnIndex(namedNodeMap);
            int n2 = this.getLineIndex(namedNodeMap);
            Node node3 = namedNodeMap.getNamedItem(REALPART);
            if (node3 == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            dArray[n2][n] = Double.parseDouble(node3.getNodeValue());
            Node node4 = namedNodeMap.getNamedItem(IMGPART);
            if (node4 == null) continue;
            bl = false;
            dArray2[n2][n] = Double.parseDouble(node4.getNodeValue());
        }
        return bl;
    }
}

