/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.io;

import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxCodecRegistry;
import java.util.Map;
import java.util.logging.Logger;
import org.scilab.modules.graph.io.ScilabObjectCodec;
import org.scilab.modules.graph.io.ScilabStringCodec;
import org.scilab.modules.types.ScilabBoolean;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ScilabBooleanCodec
extends ScilabObjectCodec {
    private static final String VALUE = "value";

    public ScilabBooleanCodec(Object object, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        super(object, stringArray, stringArray2, map);
    }

    public Node encode(mxCodec mxCodec2, Object object) {
        String string = mxCodecRegistry.getName((Object)object);
        Element element = mxCodec2.getDocument().createElement(string);
        ScilabBoolean scilabBoolean = (ScilabBoolean)object;
        if (binary) {
            int n = binaryObjects.size();
            binaryObjects.add((Object)scilabBoolean);
            mxCodec.setAttribute((Node)element, (String)"binary", (Object)"true");
            mxCodec.setAttribute((Node)element, (String)"position", (Object)n);
            return element;
        }
        mxCodec.setAttribute((Node)element, (String)"width", (Object)scilabBoolean.getWidth());
        mxCodec.setAttribute((Node)element, (String)"height", (Object)scilabBoolean.getHeight());
        for (int i = 0; i < scilabBoolean.getHeight(); ++i) {
            for (int j = 0; j < scilabBoolean.getWidth(); ++j) {
                Element element2 = mxCodec2.getDocument().createElement("data");
                mxCodec.setAttribute((Node)element2, (String)"line", (Object)i);
                mxCodec.setAttribute((Node)element2, (String)"column", (Object)j);
                mxCodec.setAttribute((Node)element2, (String)VALUE, (Object)scilabBoolean.getData()[i][j]);
                element.appendChild(element2);
            }
        }
        return element;
    }

    public Object decode(mxCodec mxCodec2, Node node, Object object) {
        ScilabBoolean scilabBoolean = null;
        try {
            int n;
            if (node.getNodeType() != 1) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            if (this.getBooleanAttribute(namedNodeMap, "binary")) {
                return binaryObjects.get(this.getIntegerAttribute(namedNodeMap, "position"));
            }
            scilabBoolean = (ScilabBoolean)this.cloneTemplate(node);
            int n2 = this.getHeight(namedNodeMap);
            if (n2 * (n = this.getWidth(namedNodeMap)) == 0) {
                return scilabBoolean;
            }
            boolean[][] blArray = new boolean[n2][n];
            this.fillData(node, blArray);
            scilabBoolean.setData(blArray);
        }
        catch (ScilabObjectCodec.UnrecognizeFormatException unrecognizeFormatException) {
            Logger.getLogger(ScilabStringCodec.class.getName()).severe(unrecognizeFormatException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(ScilabStringCodec.class.getName()).severe(numberFormatException.toString());
        }
        return scilabBoolean;
    }

    private void fillData(Node node, boolean[][] blArray) throws ScilabObjectCodec.UnrecognizeFormatException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            int n = this.getColumnIndex(namedNodeMap);
            int n2 = this.getLineIndex(namedNodeMap);
            Node node3 = namedNodeMap.getNamedItem(VALUE);
            if (node3 == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException();
            }
            blArray[n2][n] = Boolean.parseBoolean(node3.getNodeValue());
        }
    }
}

