/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.scilab.modules.commons.OS;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.ScilabGraphMessages;
import org.scilab.modules.gui.menuitem.MenuItem;

public class ZoomInAction
extends DefaultAction {
    public static final String NAME = ScilabGraphMessages.ZOOM_IN;
    public static final String SMALL_ICON = "zoom-in";
    public static final int MNEMONIC_KEY = 107;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String ZOOM_IN = "zoomIn";

    public ZoomInAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
        CustomMouseWheelListener customMouseWheelListener = new CustomMouseWheelListener(scilabGraph);
        scilabGraph.getAsComponent().addMouseWheelListener((MouseWheelListener)customMouseWheelListener);
        ActionMap actionMap = scilabGraph.getAsComponent().getActionMap();
        InputMap inputMap = scilabGraph.getAsComponent().getInputMap();
        actionMap.put(ZOOM_IN, (Action)((Object)this));
        KeyStroke[] keyStrokeArray = OS.get() == OS.MAC ? new KeyStroke[]{KeyStroke.getKeyStroke(47, ACCELERATOR_KEY), KeyStroke.getKeyStroke(47, ACCELERATOR_KEY | 0x40)} : new KeyStroke[]{KeyStroke.getKeyStroke(61, ACCELERATOR_KEY), KeyStroke.getKeyStroke(61, ACCELERATOR_KEY | 0x40), KeyStroke.getKeyStroke(43, ACCELERATOR_KEY), KeyStroke.getKeyStroke(43, ACCELERATOR_KEY | 0x40)};
        for (KeyStroke keyStroke : keyStrokeArray) {
            inputMap.put(keyStroke, ZOOM_IN);
        }
    }

    public static JButton zoominButton(ScilabGraph scilabGraph) {
        return ZoomInAction.createButton(scilabGraph, ZoomInAction.class);
    }

    public static MenuItem zoominMenu(ScilabGraph scilabGraph) {
        return ZoomInAction.createMenu(scilabGraph, ZoomInAction.class);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getGraph(actionEvent).getAsComponent().zoomIn();
    }

    private static final class CustomMouseWheelListener
    implements MouseWheelListener {
        private final ScilabGraph scilabGraph;

        public CustomMouseWheelListener(ScilabGraph scilabGraph) {
            this.scilabGraph = scilabGraph;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if ((mouseWheelEvent.getModifiers() & ACCELERATOR_KEY) != 0 && mouseWheelEvent.getWheelRotation() < 0) {
                this.scilabGraph.getAsComponent().zoomIn();
            }
        }
    }
}

