/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicView;

import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;

public class GuiLogView
implements GraphicView {
    private static GuiLogView me;
    private JEditorPane htmlLogPane;
    private JFrame frame = new JFrame("GuiLogView");

    public static GuiLogView createGuiLogView() {
        if (me == null) {
            me = new GuiLogView();
        }
        return me;
    }

    private GuiLogView() {
        this.frame.setDefaultCloseOperation(3);
        this.htmlLogPane = new JEditorPane();
        this.htmlLogPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.htmlLogPane);
        this.frame.setContentPane(jScrollPane);
        this.frame.setVisible(false);
        this.frame.setSize(800, 600);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    @Override
    public void createObject(Integer n) {
        try {
            int n2 = (Integer)GraphicController.getController().getProperty(n, 29);
            Document document = this.htmlLogPane.getDocument();
            document.insertString(document.getLength(), "+++" + n + " Object Created type is " + n2 + ".\n", null);
            this.htmlLogPane.setCaretPosition(document.getLength());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void deleteObject(Integer n) {
        try {
            Document document = this.htmlLogPane.getDocument();
            document.insertString(document.getLength(), "---" + n + " Object Deleted.\n", null);
            this.htmlLogPane.setCaretPosition(document.getLength());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void updateObject(Integer n, int n2) {
        try {
            Document document = this.htmlLogPane.getDocument();
            document.insertString(document.getLength(), "===" + n + " Object Property " + n2 + " Updated.\n", null);
            this.htmlLogPane.setCaretPosition(document.getLength());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

