/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicObject;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class ClippableProperty {
    private ClipStateType clipState;
    private double[] clipBox;
    private boolean clipBoxSet;

    public ClippableProperty() {
        this.clipState = ClipStateType.OFF;
        this.clipBox = new double[4];
        this.clipBoxSet = false;
    }

    public ClippableProperty(ClippableProperty clippableProperty) {
        this.clipState = clippableProperty.clipState;
        this.clipBox = new double[4];
        for (int i = 0; i < this.clipBox.length; ++i) {
            this.clipBox[i] = clippableProperty.clipBox[i];
        }
        this.clipBoxSet = clippableProperty.clipBoxSet;
    }

    public Double[] getClipBox() {
        Double[] doubleArray = new Double[this.clipBox.length];
        for (int i = 0; i < this.clipBox.length; ++i) {
            doubleArray[i] = this.clipBox[i];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setClipBox(Double[] doubleArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (!this.clipBoxSet) {
            this.clipBoxSet = true;
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        if (updateStatus == GraphicObject.UpdateStatus.Success) {
            for (int i = 0; i < doubleArray.length; ++i) {
                this.clipBox[i] = doubleArray[i];
            }
        } else {
            for (int i = 0; i < doubleArray.length; ++i) {
                if (this.clipBox[i] == doubleArray[i]) continue;
                this.clipBox[i] = doubleArray[i];
                updateStatus = GraphicObject.UpdateStatus.Success;
            }
        }
        return updateStatus;
    }

    public ClipStateType getClipState() {
        return this.clipState;
    }

    public GraphicObject.UpdateStatus setClipState(ClipStateType clipStateType) {
        if (clipStateType == ClipStateType.ON && !this.clipBoxSet) {
            clipStateType = ClipStateType.CLIPGRF;
        }
        if (this.clipState != clipStateType) {
            this.clipState = clipStateType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getClipBoxSet() {
        return this.clipBoxSet;
    }

    public GraphicObject.UpdateStatus setClipBoxSet(Boolean bl) {
        if (this.clipBoxSet != bl) {
            this.clipBoxSet = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public static enum ClipStateType {
        OFF,
        CLIPGRF,
        ON;


        public static ClipStateType intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return OFF;
                }
                case 1: {
                    return CLIPGRF;
                }
                case 2: {
                    return ON;
                }
            }
            return null;
        }
    }

    public static enum ClippablePropertyType {
        CLIPSTATE,
        CLIPBOX,
        CLIPBOXSET;

    }
}

