/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.axis;

import java.util.ArrayList;
import org.scilab.modules.graphic_objects.contouredObject.ClippableContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.textObject.Font;

public class Axis
extends ClippableContouredObject {
    private static final int DEFAULT_NUMBER_OF_TICKS = 10;
    private TicksDirection ticksDirection = TicksDirection.TOP;
    private double[] xTicksCoords = new double[10];
    private double[] yTicksCoords = new double[1];
    private int ticksColor = 0;
    private boolean ticksSegment = false;
    private int ticksStyle;
    private int subticks;
    private ArrayList<String> ticksLabels = new ArrayList(10);
    private ArrayList<String> ticksInterpreters = new ArrayList(10);
    private String formatn = new String("");
    private Font font = new Font();

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 207: {
                return AxisProperty.TICKSDIRECTION;
            }
            case 208: {
                return AxisProperty.XNUMBERTICKS;
            }
            case 209: {
                return AxisProperty.YNUMBERTICKS;
            }
            case 210: {
                return AxisProperty.XTICKSCOORDS;
            }
            case 211: {
                return AxisProperty.YTICKSCOORDS;
            }
            case 212: {
                return AxisProperty.TICKSCOLOR;
            }
            case 213: {
                return AxisProperty.TICKSSEGMENT;
            }
            case 214: {
                return AxisProperty.TICKSSTYLE;
            }
            case 215: {
                return AxisProperty.SUBTICKS;
            }
            case 216: {
                return AxisProperty.NUMBERTICKSLABELS;
            }
            case 217: {
                return AxisProperty.TICKSLABELS;
            }
            case 218: {
                return AxisProperty.TICKSINTERPRETERS;
            }
            case 219: {
                return AxisProperty.FORMATN;
            }
            case 220: {
                return AxisProperty.FONT;
            }
            case 221: {
                return Font.FontProperty.STYLE;
            }
            case 222: {
                return Font.FontProperty.SIZE;
            }
            case 223: {
                return Font.FontProperty.COLOR;
            }
            case 224: {
                return Font.FontProperty.FRACTIONAL;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == AxisProperty.TICKSDIRECTION) {
            return this.getTicksDirection();
        }
        if (object == AxisProperty.XNUMBERTICKS) {
            return this.getXNumberTicks();
        }
        if (object == AxisProperty.YNUMBERTICKS) {
            return this.getYNumberTicks();
        }
        if (object == AxisProperty.XTICKSCOORDS) {
            return this.getXTicksCoords();
        }
        if (object == AxisProperty.YTICKSCOORDS) {
            return this.getYTicksCoords();
        }
        if (object == AxisProperty.TICKSCOLOR) {
            return this.getTicksColor();
        }
        if (object == AxisProperty.TICKSSEGMENT) {
            return this.getTicksSegment();
        }
        if (object == AxisProperty.TICKSSTYLE) {
            return this.getTicksStyle();
        }
        if (object == AxisProperty.SUBTICKS) {
            return this.getSubticks();
        }
        if (object == AxisProperty.NUMBERTICKSLABELS) {
            return this.getNumberTicksLabels();
        }
        if (object == AxisProperty.TICKSLABELS) {
            return this.getTicksLabels();
        }
        if (object == AxisProperty.TICKSINTERPRETERS) {
            return this.getTicksInterpreters();
        }
        if (object == AxisProperty.FORMATN) {
            return this.getFormatn();
        }
        if (object == AxisProperty.FONT) {
            return this.getFont();
        }
        if (object == Font.FontProperty.STYLE) {
            return this.getStyle();
        }
        if (object == Font.FontProperty.SIZE) {
            return this.getSize();
        }
        if (object == Font.FontProperty.COLOR) {
            return this.getColor();
        }
        if (object == Font.FontProperty.FRACTIONAL) {
            return this.getFractional();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == AxisProperty.TICKSDIRECTION) {
            this.setTicksDirection((Integer)object2);
        } else if (object == AxisProperty.XTICKSCOORDS) {
            this.setXTicksCoords((Double[])object2);
        } else if (object == AxisProperty.YTICKSCOORDS) {
            this.setYTicksCoords((Double[])object2);
        } else if (object == AxisProperty.TICKSCOLOR) {
            this.setTicksColor((Integer)object2);
        } else if (object == AxisProperty.TICKSSEGMENT) {
            this.setTicksSegment((Boolean)object2);
        } else if (object == AxisProperty.TICKSSTYLE) {
            this.setTicksStyle((Integer)object2);
        } else if (object == AxisProperty.SUBTICKS) {
            this.setSubticks((Integer)object2);
        } else if (object == AxisProperty.TICKSLABELS) {
            this.setTicksLabels((String[])object2);
        } else if (object == AxisProperty.TICKSINTERPRETERS) {
            this.setTicksInterpreters((String[])object2);
        } else if (object == AxisProperty.FORMATN) {
            this.setFormatn((String)object2);
        } else if (object == AxisProperty.FONT) {
            this.setFont((Font)object2);
        } else if (object == Font.FontProperty.STYLE) {
            this.setStyle((Integer)object2);
        } else if (object == Font.FontProperty.SIZE) {
            this.setSize((Double)object2);
        } else if (object == Font.FontProperty.COLOR) {
            this.setColor((Integer)object2);
        } else if (object == Font.FontProperty.FRACTIONAL) {
            this.setFractional((Boolean)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Font getFont() {
        return this.font;
    }

    public GraphicObject.UpdateStatus setFont(Font font) {
        this.font = font;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getStyle() {
        return this.font.getStyle();
    }

    public GraphicObject.UpdateStatus setStyle(Integer n) {
        this.font.setStyle(n);
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getSize() {
        return this.font.getSize();
    }

    public GraphicObject.UpdateStatus setSize(Double d) {
        this.font.setSize(d);
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getColor() {
        return this.font.getColor();
    }

    public GraphicObject.UpdateStatus setColor(Integer n) {
        this.font.setColor(n);
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getFractional() {
        return this.font.getFractional();
    }

    public GraphicObject.UpdateStatus setFractional(Boolean bl) {
        this.font.setFractional(bl);
        return GraphicObject.UpdateStatus.Success;
    }

    public String getFormatn() {
        return this.formatn;
    }

    public GraphicObject.UpdateStatus setFormatn(String string) {
        this.formatn = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getTicksColor() {
        return this.ticksColor;
    }

    public GraphicObject.UpdateStatus setTicksColor(Integer n) {
        this.ticksColor = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getTicksDirection() {
        return this.getTicksDirectionAsEnum().ordinal();
    }

    public TicksDirection getTicksDirectionAsEnum() {
        return this.ticksDirection;
    }

    public GraphicObject.UpdateStatus setTicksDirection(Integer n) {
        this.setTicksDirectionAsEnum(TicksDirection.values()[n]);
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setTicksDirectionAsEnum(TicksDirection ticksDirection) {
        this.ticksDirection = ticksDirection;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getNumberTicksLabels() {
        return this.ticksLabels.size();
    }

    public String[] getTicksLabels() {
        String[] stringArray = new String[this.ticksLabels.size()];
        for (int i = 0; i < this.ticksLabels.size(); ++i) {
            stringArray[i] = new String(this.ticksLabels.get(i));
        }
        return stringArray;
    }

    public ArrayList<String> getTicksLabelsAsArrayList() {
        return this.ticksLabels;
    }

    public GraphicObject.UpdateStatus setTicksLabels(String[] stringArray) {
        if (!this.ticksLabels.isEmpty()) {
            this.ticksLabels.clear();
            this.ticksInterpreters.clear();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.ticksLabels.add(new String(stringArray[i]));
            this.ticksInterpreters.add(new String("auto"));
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setTicksLabelsAsArrayList(ArrayList<String> arrayList) {
        if (!this.ticksLabels.isEmpty()) {
            this.ticksLabels.clear();
            this.ticksInterpreters.clear();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.ticksLabels.add(new String(arrayList.get(i)));
            this.ticksInterpreters.add(new String("auto"));
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public String[] getTicksInterpreters() {
        String[] stringArray = new String[this.ticksInterpreters.size()];
        for (int i = 0; i < this.ticksInterpreters.size(); ++i) {
            stringArray[i] = new String(this.ticksInterpreters.get(i));
        }
        return stringArray;
    }

    public ArrayList<String> getTicksInterpretersAsArrayList() {
        return this.ticksInterpreters;
    }

    public GraphicObject.UpdateStatus setTicksInterpreters(String[] stringArray) {
        if (!this.ticksInterpreters.isEmpty()) {
            this.ticksInterpreters.clear();
        }
        for (int i = 0; i < this.ticksLabels.size(); ++i) {
            this.ticksInterpreters.add(new String(stringArray[Math.min(i, stringArray.length - 1)]));
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setTicksInterpretersAsArrayList(ArrayList<String> arrayList) {
        if (!this.ticksInterpreters.isEmpty()) {
            this.ticksInterpreters.clear();
        }
        for (int i = 0; i < this.ticksLabels.size(); ++i) {
            this.ticksInterpreters.add(new String(arrayList.get(Math.min(i, arrayList.size() - 1))));
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getTicksSegment() {
        return this.ticksSegment;
    }

    public GraphicObject.UpdateStatus setTicksSegment(Boolean bl) {
        this.ticksSegment = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getTicksStyle() {
        return this.ticksStyle;
    }

    public GraphicObject.UpdateStatus setTicksStyle(Integer n) {
        this.ticksStyle = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getSubticks() {
        return this.subticks;
    }

    public GraphicObject.UpdateStatus setSubticks(Integer n) {
        this.subticks = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getXNumberTicks() {
        return this.xTicksCoords.length;
    }

    public Integer getYNumberTicks() {
        return this.yTicksCoords.length;
    }

    public Double[] getXTicksCoords() {
        Double[] doubleArray = new Double[this.xTicksCoords.length];
        for (int i = 0; i < this.xTicksCoords.length; ++i) {
            doubleArray[i] = this.xTicksCoords[i];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setXTicksCoords(Double[] doubleArray) {
        if (doubleArray.length != this.xTicksCoords.length) {
            this.xTicksCoords = new double[doubleArray.length];
        }
        for (int i = 0; i < this.xTicksCoords.length; ++i) {
            this.xTicksCoords[i] = doubleArray[i];
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getYTicksCoords() {
        Double[] doubleArray = new Double[this.yTicksCoords.length];
        for (int i = 0; i < this.yTicksCoords.length; ++i) {
            doubleArray[i] = this.yTicksCoords[i];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setYTicksCoords(Double[] doubleArray) {
        if (doubleArray.length != this.yTicksCoords.length) {
            this.yTicksCoords = new double[doubleArray.length];
        }
        for (int i = 0; i < this.yTicksCoords.length; ++i) {
            this.yTicksCoords[i] = doubleArray[i];
        }
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 3;
    }

    public static enum TicksDirection {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }

    private static enum AxisProperty {
        TICKSDIRECTION,
        XNUMBERTICKS,
        YNUMBERTICKS,
        XTICKSCOORDS,
        YTICKSCOORDS,
        TICKSCOLOR,
        TICKSSEGMENT,
        TICKSSTYLE,
        SUBTICKS,
        NUMBERTICKSLABELS,
        TICKSLABELS,
        TICKSINTERPRETERS,
        FORMATN,
        FONT;

    }
}

