/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.axes;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class Box {
    private BoxType box;
    private int hiddenAxisColor;
    private boolean[] tightLimits;
    private double[] dataBounds;
    private double[] realDataBounds;
    private boolean zoomEnabled;
    private double[] zoomBox;
    private boolean autoScale;
    private boolean autoStretch;
    private boolean firstPlot;

    public Box() {
        this.box = BoxType.OFF;
        this.hiddenAxisColor = 0;
        this.tightLimits = new boolean[]{false, false, false};
        this.dataBounds = new double[]{0.0, 1.0, 0.0, 1.0, -1.0, 1.0};
        this.realDataBounds = new double[6];
        this.zoomEnabled = false;
        this.zoomBox = new double[6];
        this.autoScale = false;
        this.autoStretch = true;
        this.firstPlot = true;
    }

    public Box(Box box) {
        int n;
        this.box = box.box;
        this.hiddenAxisColor = box.hiddenAxisColor;
        this.tightLimits = new boolean[3];
        for (n = 0; n < this.tightLimits.length; ++n) {
            this.tightLimits[n] = box.tightLimits[n];
        }
        this.dataBounds = new double[6];
        for (n = 0; n < this.dataBounds.length; ++n) {
            this.dataBounds[n] = box.dataBounds[n];
        }
        this.realDataBounds = new double[6];
        for (n = 0; n < this.realDataBounds.length; ++n) {
            this.realDataBounds[n] = box.realDataBounds[n];
        }
        this.zoomEnabled = box.zoomEnabled;
        this.zoomBox = new double[6];
        for (n = 0; n < this.zoomBox.length; ++n) {
            this.zoomBox[n] = box.zoomBox[n];
        }
        this.autoScale = box.autoScale;
        this.autoStretch = box.autoStretch;
        this.firstPlot = box.firstPlot;
    }

    public Boolean getAutoScale() {
        return this.autoScale;
    }

    public Boolean getAutoStretch() {
        return this.autoStretch;
    }

    public GraphicObject.UpdateStatus setAutoScale(Boolean bl) {
        if (this.autoScale != bl) {
            this.autoScale = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public GraphicObject.UpdateStatus setAutoStretch(Boolean bl) {
        if (this.autoStretch != bl) {
            this.autoStretch = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public BoxType getBox() {
        return this.box;
    }

    public GraphicObject.UpdateStatus setBox(BoxType boxType) {
        if (this.box != boxType) {
            this.box = boxType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getDataBounds() {
        Double[] doubleArray = new Double[6];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = this.dataBounds[i];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDataBounds(Double[] doubleArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        int n = Math.min(this.dataBounds.length, doubleArray.length);
        for (int i = 0; i < n; ++i) {
            if (this.dataBounds[i] == doubleArray[i]) continue;
            this.dataBounds[i] = doubleArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer getHiddenAxisColor() {
        return this.hiddenAxisColor;
    }

    public GraphicObject.UpdateStatus setHiddenAxisColor(Integer n) {
        if (this.hiddenAxisColor != n) {
            this.hiddenAxisColor = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getRealDataBounds() {
        Double[] doubleArray = new Double[6];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = this.realDataBounds[i];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setRealDataBounds(Double[] doubleArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        int n = Math.min(this.realDataBounds.length, doubleArray.length);
        for (int i = 0; i < n; ++i) {
            if (this.realDataBounds[i] == doubleArray[i]) continue;
            this.realDataBounds[i] = doubleArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Boolean getXTightLimits() {
        return this.tightLimits[0];
    }

    public Boolean getYTightLimits() {
        return this.tightLimits[1];
    }

    public Boolean getZTightLimits() {
        return this.tightLimits[2];
    }

    public GraphicObject.UpdateStatus setXTightLimits(Boolean bl) {
        if (this.tightLimits[0] != bl) {
            this.tightLimits[0] = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public GraphicObject.UpdateStatus setYTightLimits(Boolean bl) {
        if (this.tightLimits[1] != bl) {
            this.tightLimits[1] = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public GraphicObject.UpdateStatus setZTightLimits(Boolean bl) {
        if (this.tightLimits[2] != bl) {
            this.tightLimits[2] = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getZoomEnabled() {
        return this.zoomEnabled;
    }

    public GraphicObject.UpdateStatus setZoomEnabled(Boolean bl) {
        if (this.zoomEnabled != bl) {
            this.zoomEnabled = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getZoomBox() {
        Double[] doubleArray = new Double[6];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = this.zoomBox[i];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setZoomBox(Double[] doubleArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        int n = Math.min(this.zoomBox.length, doubleArray.length);
        for (int i = 0; i < n; ++i) {
            if (this.zoomBox[i] == doubleArray[i]) continue;
            this.zoomBox[i] = doubleArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Boolean getFirstPlot() {
        return this.firstPlot;
    }

    public GraphicObject.UpdateStatus setFirstPlot(Boolean bl) {
        if (this.firstPlot != bl) {
            this.firstPlot = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public static enum BoxType {
        OFF,
        ON,
        HIDDEN_AXES,
        BACK_HALF;


        public static BoxType intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return OFF;
                }
                case 1: {
                    return ON;
                }
                case 2: {
                    return HIDDEN_AXES;
                }
                case 3: {
                    return BACK_HALF;
                }
            }
            return null;
        }
    }

    public static enum BoxProperty {
        BOX,
        HIDDENAXISCOLOR,
        XTIGHTLIMITS,
        YTIGHTLIMITS,
        ZTIGHTLIMITS,
        DATABOUNDS,
        REALDATABOUNDS,
        ZOOMENABLED,
        ZOOMBOX,
        AUTOSCALE,
        AUTOSTRETCH,
        FIRSTPLOT;

    }
}

