/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.arc;

import org.scilab.modules.graphic_objects.contouredObject.ClippableContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;

public class Arc
extends ClippableContouredObject {
    private double[] upperLeftPoint;
    private double width = 0.0;
    private double height = 0.0;
    private double startAngle = 0.0;
    private double endAngle = 0.0;
    private ArcDrawingMethod arcDrawingMethod = ArcDrawingMethod.LINES;

    public Arc() {
        this.upperLeftPoint = new double[]{0.0, 0.0, 0.0};
    }

    @Override
    public Arc clone() {
        Arc arc = (Arc)super.clone();
        arc.upperLeftPoint = new double[]{0.0, 0.0, 0.0};
        return arc;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 104: {
                return ArcProperty.UPPERLEFTPOINT;
            }
            case 105: {
                return ArcProperty.WIDTH;
            }
            case 106: {
                return ArcProperty.HEIGHT;
            }
            case 107: {
                return ArcProperty.STARTANGLE;
            }
            case 108: {
                return ArcProperty.ENDANGLE;
            }
            case 109: {
                return ArcProperty.ARCDRAWINGMETHOD;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == ArcProperty.UPPERLEFTPOINT) {
            return this.getUpperLeftPoint();
        }
        if (object == ArcProperty.WIDTH) {
            return this.getWidth();
        }
        if (object == ArcProperty.HEIGHT) {
            return this.getHeight();
        }
        if (object == ArcProperty.STARTANGLE) {
            return this.getStartAngle();
        }
        if (object == ArcProperty.ENDANGLE) {
            return this.getEndAngle();
        }
        if (object == ArcProperty.ARCDRAWINGMETHOD) {
            return this.getArcDrawingMethod();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == ArcProperty.UPPERLEFTPOINT) {
            this.setUpperLeftPoint((Double[])object2);
        } else if (object == ArcProperty.WIDTH) {
            this.setWidth((Double)object2);
        } else if (object == ArcProperty.HEIGHT) {
            this.setHeight((Double)object2);
        } else if (object == ArcProperty.STARTANGLE) {
            this.setStartAngle((Double)object2);
        } else if (object == ArcProperty.ENDANGLE) {
            this.setEndAngle((Double)object2);
        } else if (object == ArcProperty.ARCDRAWINGMETHOD) {
            this.setArcDrawingMethod((Integer)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getArcDrawingMethod() {
        return this.getArcDrawingMethodAsEnum().ordinal();
    }

    public ArcDrawingMethod getArcDrawingMethodAsEnum() {
        return this.arcDrawingMethod;
    }

    public GraphicObject.UpdateStatus setArcDrawingMethod(Integer n) {
        this.setArcDrawingMethodAsEnum(ArcDrawingMethod.intToEnum(n));
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setArcDrawingMethodAsEnum(ArcDrawingMethod arcDrawingMethod) {
        this.arcDrawingMethod = arcDrawingMethod;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getEndAngle() {
        return this.endAngle;
    }

    public GraphicObject.UpdateStatus setEndAngle(Double d) {
        this.endAngle = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getHeight() {
        return this.height;
    }

    public GraphicObject.UpdateStatus setHeight(Double d) {
        this.height = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getStartAngle() {
        return this.startAngle;
    }

    public GraphicObject.UpdateStatus setStartAngle(Double d) {
        this.startAngle = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getUpperLeftPoint() {
        Double[] doubleArray = new Double[]{this.upperLeftPoint[0], this.upperLeftPoint[1], this.upperLeftPoint[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setUpperLeftPoint(Double[] doubleArray) {
        this.upperLeftPoint[0] = doubleArray[0];
        this.upperLeftPoint[1] = doubleArray[1];
        this.upperLeftPoint[2] = doubleArray[2];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getWidth() {
        return this.width;
    }

    public GraphicObject.UpdateStatus setWidth(Double d) {
        this.width = d;
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 0;
    }

    public static enum ArcDrawingMethod {
        NURBS,
        LINES;


        public static ArcDrawingMethod intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return NURBS;
                }
                case 1: {
                    return LINES;
                }
            }
            return null;
        }
    }

    public static enum ArcProperty {
        UPPERLEFTPOINT,
        WIDTH,
        HEIGHT,
        STARTANGLE,
        ENDANGLE,
        ARCDRAWINGMETHOD;

    }
}

