/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.scilab.modules.graphic_objects.DataLoader;
import org.scilab.modules.graphic_objects.JavaObjectLoader;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class MainDataLoader {
    private static final Set<Integer> JAVA_OBJECTS = new HashSet<Integer>(Arrays.asList(0, 4, 16, 17));

    public static int getTextureWidth(Integer n) {
        return DataLoader.getTextureWidth(n);
    }

    public static int getTextureHeight(Integer n) {
        return DataLoader.getTextureHeight(n);
    }

    public static ByteBuffer getTextureData(Integer n) {
        return DataLoader.getTextureData(n);
    }

    public static boolean isTextureRowOrder(Integer n) {
        return DataLoader.isTextureRowOrder(n) != 0;
    }

    public static void disposeTextureData(Integer n, ByteBuffer byteBuffer) {
        DataLoader.disposeTextureData(n, byteBuffer);
    }

    public static int getTextureImageType(Integer n) {
        return DataLoader.getTextureImageType(n);
    }

    public static int getTextureDataType(Integer n) {
        return DataLoader.getTextureDataType(n);
    }

    public static int getTextureGLType(Integer n) {
        return DataLoader.getTextureGLType(n);
    }

    public static void fillTextureCoordinates(Integer n, FloatBuffer floatBuffer, int n2) {
        DataLoader.fillTextureCoordinates(n, floatBuffer, n2);
    }

    public static void fillTextureData(Integer n, ByteBuffer byteBuffer, int n2) {
        DataLoader.fillTextureData(n, byteBuffer, n2);
    }

    public static void fillTextureData(Integer n, ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, int n6) {
        DataLoader.fillSubTextureData(n, byteBuffer, n2, n3, n4, n5, n6);
    }

    public static int getDataSize(Integer n) throws ObjectRemovedException {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n2 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n2)) {
            return JavaObjectLoader.getDataSize(n);
        }
        return DataLoader.getDataSize(n);
    }

    public static void fillVertices(Integer n, FloatBuffer floatBuffer, int n2, int n3, double[] dArray, double[] dArray2, int n4) throws ObjectRemovedException {
        Integer n5 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n5 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n5)) {
            JavaObjectLoader.fillVertices(n, floatBuffer, n2, n3, dArray, dArray2, n4);
        } else {
            DataLoader.fillVertices(n, floatBuffer, floatBuffer.capacity(), n2, n3, dArray, dArray2, n4);
        }
    }

    public static void fillNormals(Integer n, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n2) throws ObjectRemovedException {
        Integer n3 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n3 == null) {
            throw new ObjectRemovedException(n);
        }
        DataLoader.fillNormals(n, floatBuffer, floatBuffer2, floatBuffer2.capacity(), n2);
    }

    public static void fillColors(Integer n, FloatBuffer floatBuffer, int n2) throws ObjectRemovedException {
        Integer n3 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n3 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n3)) {
            JavaObjectLoader.fillColors(n, floatBuffer, n2);
        } else {
            DataLoader.fillColors(n, floatBuffer, floatBuffer.capacity(), n2);
        }
    }

    public static int getIndicesSize(Integer n) throws ObjectRemovedException {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n2 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n2)) {
            return JavaObjectLoader.getIndicesSize(n);
        }
        return DataLoader.getIndicesSize(n);
    }

    public static int fillIndices(Integer n, IntBuffer intBuffer, int n2) throws ObjectRemovedException {
        Integer n3 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n3 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n3)) {
            return JavaObjectLoader.fillIndices(n, intBuffer, n2);
        }
        return DataLoader.fillIndices(n, intBuffer, intBuffer.capacity(), n2);
    }

    public static int getWireIndicesSize(Integer n) throws ObjectRemovedException {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n2 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n2)) {
            return JavaObjectLoader.getWireIndicesSize(n);
        }
        return DataLoader.getWireIndicesSize(n);
    }

    public static int fillWireIndices(Integer n, IntBuffer intBuffer, int n2) throws ObjectRemovedException {
        Integer n3 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n3 == null) {
            throw new ObjectRemovedException(n);
        }
        if (JAVA_OBJECTS.contains(n3)) {
            return JavaObjectLoader.fillWireIndices(n, intBuffer, n2);
        }
        return DataLoader.fillWireIndices(n, intBuffer, intBuffer.capacity(), n2);
    }

    public static int getMarkIndicesSize(String string) {
        return 0;
    }

    public static int fillMarkIndices(String string, IntBuffer intBuffer) {
        return 0;
    }

    public static int getLogMask(Integer n) {
        try {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
            Integer n2 = graphicObject.getParentAxes();
            Axes axes = (Axes)GraphicController.getController().getObjectFromId(n2);
            int n3 = 0;
            if (axes.getXAxisLogFlag().booleanValue()) {
                ++n3;
            }
            if (axes.getYAxisLogFlag().booleanValue()) {
                n3 += 2;
            }
            if (axes.getZAxisLogFlag().booleanValue()) {
                n3 += 4;
            }
            return n3;
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

