/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.jvm;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Vector;
import org.scilab.modules.jvm.ScilabClassLoader;

public class ClassPath {
    private static final Class[] parameters = new Class[]{URL.class};
    private static Vector<URL> queued = new Vector();

    public static void addFile(String string, int n) throws IOException {
        ClassPath.addFile(new File(string), n);
    }

    public static void addFile(File file, int n) throws IOException {
        ClassPath.addURL(file.toURI().toURL(), n);
    }

    public static void addURL(URL uRL, int n) {
        switch (n) {
            case 0: {
                ((ScilabClassLoader)ClassLoader.getSystemClassLoader()).addURL(uRL);
                break;
            }
            case 1: {
                queued.add(uRL);
            }
        }
    }

    public static String[] getClassPath() {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        String[] stringArray = new String[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            stringArray[i] = uRLArray[i].getFile();
        }
        return stringArray;
    }

    public static void loadBackGroundClassPath() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Iterator<URL> iterator = queued.iterator();
                    while (iterator.hasNext()) {
                        ClassPath.addURL(iterator.next(), 0);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error : " + exception.getLocalizedMessage());
                }
            }
        };
        thread.start();
    }
}

