/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import javax.swing.AbstractButton;
import org.scilab.modules.preferences.Component.Entry;
import org.scilab.modules.preferences.Component.FileSelector;
import org.scilab.modules.preferences.Component.Scroll;
import org.scilab.modules.preferences.Component.Table;
import org.scilab.modules.preferences.Component.TextArea;
import org.scilab.modules.preferences.ComponentFactory;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.scilab.modules.preferences.XSentinel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XUpdateVisitor {
    private final Map<Component, XSentinel> matching;

    public XUpdateVisitor(Map<Component, XSentinel> map) {
        this.matching = map;
    }

    public final Component build(Container container, Node node, Node node2, int n) {
        Component component = this.buildPeerFor(node2);
        Object object = this.getLayoutConstraints(node, node2);
        if (n >= 0) {
            container.add(component, object, n);
        } else {
            container.add(component, object);
        }
        return component;
    }

    public final void forget(Container container, Component component) {
        container.remove(component);
        this.matching.remove(component);
    }

    public final void visit(Container container, Node node) {
        XSentinel xSentinel;
        Component component;
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = container instanceof Scroll ? ((Scroll)container).getXComponentCount() : container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            if (!this.isVisible(node2)) continue;
            if (n < n3) {
                component = container instanceof Scroll ? ((Scroll)container).getXComponent(n) : container.getComponent(n);
                xSentinel = this.matching.get(component);
                if (xSentinel == null || !xSentinel.checks(node2)) {
                    this.forget(container, component);
                    component = this.build(container, node, node2, n);
                }
            } else {
                component = this.build(container, node, node2, -1);
            }
            if (component instanceof XComponent) {
                Container container2 = (Container)component;
                this.visit(container2, node2);
            }
            ++n;
        }
        while (n < container.getComponentCount()) {
            component = container.getComponent(n);
            if (component instanceof XComponent) {
                this.forget(container, component);
                continue;
            }
            ++n;
        }
        xSentinel = this.matching.get(container);
        if (xSentinel == null) {
            xSentinel = new XSentinel(container, node);
            this.matching.put(container, xSentinel);
            if (container instanceof XComponent) {
                this.addListeners(container, node, xSentinel);
            }
        } else {
            xSentinel.setPeer(node);
        }
        if (container instanceof XComponent) {
            XComponent xComponent = (XComponent)((Object)container);
            xComponent.refresh(node);
        }
    }

    final Object getLayoutConstraints(Node node, Node node2) {
        if (XConfigManager.getAttribute(node, "layout").equals("border")) {
            return XConfigManager.getAttribute(node2, "border-side");
        }
        if (node.getNodeName().equals("Grid")) {
            return node2;
        }
        return null;
    }

    public final boolean isVisible(Node node) {
        if (node.getNodeName().equals("mouseClicked")) {
            return false;
        }
        if (node.getNodeName().equals("actionPerformed")) {
            return false;
        }
        if (node.getNodeName().equals("entryChanged")) {
            return false;
        }
        if (node.getNodeName().startsWith("propertyChange")) {
            return false;
        }
        if (node.getNodeName().equals("#text") && node.getNodeValue().replaceAll("^[ \t\n]+$", "").equals("")) {
            return false;
        }
        if (node.getNodeName().equals("option")) {
            return false;
        }
        if (node.getNodeName().startsWith("table")) {
            return false;
        }
        if (node.getNodeName().equals("listElement")) {
            return false;
        }
        return !node.getNodeName().equals("html");
    }

    public final void addListeners(Component component, Node node, XSentinel xSentinel) {
        String string = XCommonManager.getAttribute(node, "listener");
        if (string.equals("ActionListener")) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.addActionListener(xSentinel);
                return;
            }
            if (component instanceof XChooser) {
                XChooser xChooser = (XChooser)((Object)component);
                xChooser.addActionListener(xSentinel);
                return;
            }
        }
        if (string.equals("MouseListener")) {
            component.addMouseListener(xSentinel);
            return;
        }
        if (string.equals("KeyListener")) {
            component.addKeyListener(xSentinel);
            return;
        }
        if (string.equals("EntryListener")) {
            if (component instanceof Entry) {
                ((Entry)component).getDocument().addDocumentListener(xSentinel);
                return;
            }
            if (component instanceof FileSelector) {
                ((FileSelector)component).addDocumentListener(xSentinel);
                return;
            }
            if (component instanceof TextArea) {
                ((TextArea)component).addDocumentListener(xSentinel);
                return;
            }
        }
        if (string.equals("TableListener") && component instanceof Table) {
            Table table = (Table)component;
            table.addTableModelListener(xSentinel);
            return;
        }
        if (string.startsWith("PropertyChangeListener")) {
            int n = string.indexOf(35);
            boolean bl = n > 0;
            String string2 = bl ? string.substring(n + 1) : null;
            if (component instanceof Component) {
                if (bl) {
                    component.addPropertyChangeListener(string2, xSentinel);
                } else {
                    component.addPropertyChangeListener(xSentinel);
                }
                return;
            }
        }
    }

    public final Component buildPeerFor(Node node) {
        return ComponentFactory.getComponent(node);
    }
}

