/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.preferences.ScilabPreferences;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XWizardManager;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XConfigManager
extends XCommonManager {
    private static final String RESET_DEFAULT_LAYOUT_QUESTION = Messages.gettext((String)"Are you sure you want to restore the default layout at next startup?");
    private static final String RESET_LAYOUT_TITLE = Messages.gettext((String)"Reset layout");
    public static boolean active = false;
    private static final String SCILAB_CONFIG_FILE = System.getenv("SCI") + "/modules/preferences/etc/XConfiguration.xml";
    private static final String SCILAB_CONFIG_XSL = System.getenv("SCI") + "/modules/preferences/src/xslt/XConfiguration.xsl";
    private static String USER_CONFIG_FILE;
    private static boolean mustSave;
    private static JDialog help;

    private XConfigManager() {
        throw new UnsupportedOperationException();
    }

    public static void displayAndWait(String string) {
        active = true;
        XWizardManager.active = false;
        XConfigManager.reloadTransformer(SCILAB_CONFIG_XSL);
        Frame frame = XCommonManager.getTopLevel();
        dialog = new JDialog(frame, Messages.gettext((String)"Scilab Preferences"), true);
        dialog.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"preferences-system", (String)"256x256")).getImage());
        topSwing = dialog.getContentPane();
        topSwing.setLayout(new BorderLayout());
        XConfigManager.readUserDocuments();
        if (string != null && !string.equals("")) {
            String string2 = XConfigManager.getPath(string);
            document.getDocumentElement().setAttribute("path", string2);
        }
        updated = false;
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Element element = XCommonManager.document.getDocumentElement();
                Dimension dimension = XCommonManager.dialog.getSize();
                int n = XConfigManager.getInt(element, "height", 0);
                int n2 = XConfigManager.getInt(element, "width", 0);
                if (Math.abs((double)n - dimension.getHeight()) > 0.1 || Math.abs((double)n2 - dimension.getWidth()) > 0.1) {
                    element.setAttribute("height", Integer.toString((int)dimension.getHeight()));
                    element.setAttribute("width", Integer.toString((int)dimension.getWidth()));
                }
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XConfigManager.cancel();
            }
        });
        ScilabSwingUtilities.closeOnEscape((Window)dialog);
        correspondance = new HashMap();
        if (XConfigManager.refreshDisplay()) {
            if (frame != null) {
                int n = frame.getX() + (frame.getWidth() - dialog.getWidth()) / 2;
                int n2 = frame.getY() + (frame.getHeight() - dialog.getHeight()) / 2;
                dialog.setLocation(n, n2);
            }
            dialog.setVisible(true);
        }
    }

    public static void openPreferences(String string) {
        XConfigManager.displayAndWait(string);
    }

    public static void openPreferences() {
        XConfigManager.displayAndWait(null);
    }

    private static void readUserDocuments() {
        document = XConfiguration.getXConfigurationDocument();
        NodeList nodeList = document.getElementsByTagName("toolboxes");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            try {
                document.getDocumentElement().removeChild(nodeList.item(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Element element = document.createElement("toolboxes");
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElement("body");
        element.appendChild(element2);
        List<ScilabPreferences.ToolboxInfos> list = ScilabPreferences.getToolboxesInfos();
        for (ScilabPreferences.ToolboxInfos toolboxInfos : list) {
            String string = new File(toolboxInfos.getPrefFile()).getName();
            String string2 = toolboxInfos.getName().replace(' ', '_');
            String string3 = ScilabConstants.SCIHOME.toString() + "/" + string;
            XConfigManager.createUserCopy(toolboxInfos.getPrefFile(), string3);
            Element element3 = document.createElement(string2);
            element3.setAttribute("title", toolboxInfos.getName());
            DocumentFragment documentFragment = document.createDocumentFragment();
            Document document = XConfigManager.readDocument(string3);
            Node node = document.getDocumentElement();
            node = XConfigManager.document.importNode(node, true);
            documentFragment.appendChild(node);
            element3.insertBefore(documentFragment, null);
            element.appendChild(element3);
        }
    }

    private static void WriteUserDocuments() {
        NodeList nodeList = document.getElementsByTagName("toolboxes");
        Element element = null;
        if (nodeList != null && nodeList.getLength() != 0) {
            element = (Element)nodeList.item(0);
            List<ScilabPreferences.ToolboxInfos> list = ScilabPreferences.getToolboxesInfos();
            for (ScilabPreferences.ToolboxInfos toolboxInfos : list) {
                Element element2;
                String string = toolboxInfos.getName().replace(' ', '_');
                NodeList nodeList2 = element.getElementsByTagName(string);
                if (nodeList2 == null || nodeList2.getLength() == 0 || !(element2 = (Element)nodeList2.item(0)).hasChildNodes()) continue;
                String string2 = new File(toolboxInfos.getPrefFile()).getName();
                String string3 = ScilabConstants.SCIHOME.toString() + "/" + string2;
                XConfiguration.writeDocument((String)string3, (Node)element2.getFirstChild());
            }
        }
        if (element != null) {
            document.getDocumentElement().removeChild(element);
        }
        XConfiguration.writeDocument((String)USER_CONFIG_FILE, (Node)document);
        if (element != null) {
            document.getDocumentElement().appendChild(element);
        }
    }

    private static void cancel() {
        dialog.dispose();
        XCommonManager.invalidateXSL();
        XConfiguration.invalidate();
        NodeList nodeList = document.getElementsByTagName("toolboxes");
        if (nodeList != null && nodeList.getLength() != 0) {
            Element element = (Element)nodeList.item(0);
            document.getDocumentElement().removeChild(element);
        }
        correspondance = null;
        updated = false;
    }

    public static boolean xEvent(Node[] nodeArray, Component component) {
        if (XConfigManager.generixEvent(nodeArray, component)) {
            return true;
        }
        if (nodeArray.length == 0) {
            return false;
        }
        Node node = nodeArray[0];
        String string = XConfigManager.getAttribute(node, "callback");
        if (string.equals("Save Backup")) {
            String string2 = XConfigManager.getAttribute(node, "path");
            XConfigManager.writeDocument(ScilabCommonsUtils.getCorrectedPath((String)string2), document);
            return true;
        }
        if (string.equals("Reset layout")) {
            if (ScilabModalDialog.show((Component)dialog, (String[])new String[]{RESET_DEFAULT_LAYOUT_QUESTION}, (String)RESET_LAYOUT_TITLE, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.NO_OPTION) {
                return false;
            }
            WindowsConfigurationManager.resetLayout();
            return true;
        }
        if (string.equals("Restore Backup")) {
            String string3 = XConfigManager.getAttribute(node, "path");
            try {
                XConfigManager.copyFile(new File(ScilabCommonsUtils.getCorrectedPath((String)string3)), new File(USER_CONFIG_FILE));
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            XConfiguration.invalidate();
            XConfiguration.addModifiedPath((String)"ALL");
            XConfigManager.reloadTransformer(SCILAB_CONFIG_XSL);
            document = XConfiguration.createDocument();
            List<ScilabPreferences.ToolboxInfos> list = ScilabPreferences.getToolboxesInfos();
            for (ScilabPreferences.ToolboxInfos toolboxInfos : list) {
                String string4 = new File(toolboxInfos.getPrefFile()).getName();
                String string5 = ScilabConstants.SCIHOME.toString() + "/" + string4;
                XConfigManager.refreshUserCopy(toolboxInfos.getPrefFile(), string5);
            }
            XConfigManager.readUserDocuments();
            updated = false;
            XConfigManager.refreshDisplay();
            return true;
        }
        if (string.equals("Ok")) {
            XConfigManager.WriteUserDocuments();
            dialog.dispose();
            XCommonManager.invalidateXSL();
            updated = false;
            XConfiguration.fireXConfigurationEvent();
            XConfiguration.invalidate();
            return true;
        }
        if (string.equals("Apply")) {
            updated = false;
            XConfigManager.WriteUserDocuments();
            XConfiguration.fireXConfigurationEvent();
            return true;
        }
        if (string.equals("Default")) {
            if (ScilabModalDialog.show((Component)dialog, (String[])new String[]{Messages.gettext((String)"Are you sure you want to reset all settings to the default values?")}, (String)Messages.gettext((String)"Reset"), (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.NO_OPTION) {
                return false;
            }
            Cursor cursor = dialog.getContentPane().getCursor();
            dialog.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            XConfiguration.invalidate();
            XConfiguration.addModifiedPath((String)"ALL");
            XConfigManager.reloadTransformer(SCILAB_CONFIG_XSL);
            document = XConfiguration.createDocument();
            XConfigManager.writeDocument(USER_CONFIG_FILE, document);
            List<ScilabPreferences.ToolboxInfos> list = ScilabPreferences.getToolboxesInfos();
            for (ScilabPreferences.ToolboxInfos toolboxInfos : list) {
                String string6 = new File(toolboxInfos.getPrefFile()).getName();
                String string7 = ScilabConstants.SCIHOME.toString() + "/" + string6;
                XConfigManager.refreshUserCopy(toolboxInfos.getPrefFile(), string7);
            }
            XConfigManager.readUserDocuments();
            updated = false;
            XConfigManager.refreshDisplay();
            dialog.getContentPane().setCursor(cursor);
            return true;
        }
        if (string.equals("Cancel")) {
            XConfigManager.cancel();
            return true;
        }
        return false;
    }

    protected static void writeDocument(String string, Node node) {
        if (!SCILAB_CONFIG_FILE.equals(string)) {
            XCommonManager.writeDocument(string, node);
        }
    }

    static {
        mustSave = true;
        if (ScilabConstants.SCIHOME != null && ScilabConstants.SCIHOME.canRead() && ScilabConstants.SCIHOME.canWrite()) {
            USER_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/XConfiguration.xml";
        } else {
            USER_CONFIG_FILE = SCILAB_CONFIG_FILE;
            mustSave = false;
        }
        help = null;
    }
}

