/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class NumericalSpinner
extends JSpinner
implements XComponent,
XChooser,
ChangeListener {
    private static final long serialVersionUID = -4842434795956015958L;
    private static final Double defaultInc = new Double(1.0);
    private Double min = new Double(Double.NEGATIVE_INFINITY);
    private Double max = new Double(Double.POSITIVE_INFINITY);
    private SpinnerNumberModel spinnerModel = new SpinnerNumberModel(new Double(0.0), this.min, this.max, defaultInc);
    private ActionListener actionListener;

    @Override
    public final String[] actuators() {
        return new String[]{"length", "increment", "min-value", "max-value", "value", "tooltip", "enable"};
    }

    public NumericalSpinner(Node node) {
        this.setModel(this.spinnerModel);
        this.addChangeListener(this);
        String string = XConfigManager.getAttribute(node, "length");
        this.length(string);
        String string2 = XConfigManager.getAttribute(node, "increment");
        this.increment(string2);
        String string3 = XConfigManager.getAttribute(node, "tooltip");
        this.tooltip(string3);
        String string4 = XConfigManager.getAttribute(node, "min-value");
        this.minvalue(string4);
        String string5 = XConfigManager.getAttribute(node, "max-value");
        this.maxvalue(string5);
        String string6 = XConfigManager.getAttribute(node, "value");
        this.value(string6);
        String string7 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string7.equals("true"));
    }

    @Override
    public void refresh(Node node) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = XConfigManager.getAttribute(node, "length");
        if (!string6.equals(this.length())) {
            this.length(string6);
        }
        if (!(string5 = XConfigManager.getAttribute(node, "increment")).equals(this.increment())) {
            this.increment(string5);
        }
        if (!(string4 = XConfigManager.getAttribute(node, "tooltip")).equals(this.tooltip())) {
            this.tooltip(string4);
        }
        if (!(string3 = XConfigManager.getAttribute(node, "min-value")).equals(this.minvalue())) {
            this.minvalue(string3);
        }
        if (!(string2 = XConfigManager.getAttribute(node, "max-value")).equals(this.maxvalue())) {
            this.maxvalue(string2);
        }
        if (!(string = XConfigManager.getAttribute(node, "value")).equals(this.value())) {
            this.value(string);
        }
        String string7 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string7.equals("true"));
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
    }

    public final String length() {
        return Integer.toString(((JSpinner.DefaultEditor)this.getEditor()).getTextField().getColumns());
    }

    public final String value() {
        return this.spinnerModel.getValue().toString();
    }

    public final String minvalue() {
        return this.spinnerModel.getMinimum().toString();
    }

    public final String maxvalue() {
        return this.spinnerModel.getMaximum().toString();
    }

    public final String increment() {
        return this.spinnerModel.getStepSize().toString();
    }

    public final String tooltip() {
        String string = this.getToolTipText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public final void length(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            try {
                ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setColumns(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public final void tooltip(String string) {
        if (string.equals("\"not an value'") || string.equals("")) {
            string = null;
        }
        this.setToolTipText(string);
    }

    public final void value(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            this.spinnerModel.setValue(new Double(string));
        }
    }

    public final void minvalue(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            try {
                this.spinnerModel.setMinimum(new Double(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public final void maxvalue(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            try {
                this.spinnerModel.setMaximum(new Double(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public final void increment(String string) {
        if (string.equals("\"not an value'") || string.equals("")) {
            this.spinnerModel.setStepSize(defaultInc);
        } else {
            try {
                this.spinnerModel.setStepSize(new Double(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public final Object choose() {
        return this.value();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "Spinner Value changed", System.currentTimeMillis(), 0));
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("NumericalSpinner");
        if (!this.length().equals("\"not an value'")) {
            stringBuilder.append(" length='");
            stringBuilder.append(this.length());
            stringBuilder.append("'");
        }
        if (!this.value().equals("\"not an value'")) {
            stringBuilder.append(" value='");
            stringBuilder.append(this.value());
            stringBuilder.append("'");
        }
        if (!this.minvalue().equals("\"not an value'")) {
            stringBuilder.append(" min-value='");
            stringBuilder.append(this.minvalue());
            stringBuilder.append("'");
        }
        if (!this.maxvalue().equals("\"not an value'")) {
            stringBuilder.append(" max-value='");
            stringBuilder.append(this.maxvalue());
            stringBuilder.append("'");
        }
        if (!this.increment().equals("\"not an value'")) {
            stringBuilder.append(" increment='");
            stringBuilder.append(this.increment());
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }
}

