/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.scilab.modules.preferences.XCommonManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Model
extends AbstractTableModel {
    private static final long serialVersionUID = -4786321481195930071L;
    private NodeList nodelist;
    private NodeList prevC;
    private NodeList prevR;
    private int rows;
    private int cols;

    public Model(Node node) {
        this.setNodeList(node.getChildNodes());
    }

    public void setNodeList(NodeList nodeList) {
        this.nodelist = nodeList;
    }

    @Override
    public int getColumnCount() {
        if (this.nodelist != this.prevC) {
            this.cols = 0;
            for (int i = 0; i < this.nodelist.getLength(); ++i) {
                Node node = this.nodelist.item(i);
                if (!node.getNodeName().equals("tableCol")) continue;
                ++this.cols;
            }
            this.prevC = this.nodelist;
        }
        return this.cols;
    }

    @Override
    public int getRowCount() {
        if (this.nodelist != this.prevR) {
            this.rows = 0;
            for (int i = 0; i < this.nodelist.getLength(); ++i) {
                Node node = this.nodelist.item(i);
                if (!node.getNodeName().equals("tableRow")) continue;
                ++this.rows;
            }
            this.prevR = this.nodelist;
        }
        return this.rows;
    }

    public Node getPrototypeRecord() {
        for (int i = 0; i < this.nodelist.getLength(); ++i) {
            Node node = this.nodelist.item(i);
            if (!node.getNodeName().equals("tablePrototype")) continue;
            return node;
        }
        return null;
    }

    public Node getColumnRecord(int n) {
        int n2 = n;
        for (int i = 0; i < this.nodelist.getLength(); ++i) {
            Node node = this.nodelist.item(i);
            if (!node.getNodeName().equals("tableCol")) continue;
            if (n2 == 0) {
                return node;
            }
            --n2;
        }
        return null;
    }

    public Node getRowRecord(int n) {
        int n2 = n;
        for (int i = 0; i < this.nodelist.getLength(); ++i) {
            Node node = this.nodelist.item(i);
            if (!node.getNodeName().equals("tableRow")) continue;
            if (n2 == 0) {
                return node;
            }
            --n2;
        }
        return null;
    }

    public String getColumnAttr(int n) {
        Node node = this.getColumnRecord(n);
        if (node != null) {
            return XCommonManager.getAttribute(node, "attr");
        }
        return "\"not an value'";
    }

    @Override
    public String getColumnName(int n) {
        Node node = this.getColumnRecord(n);
        if (node != null) {
            return XCommonManager.getAttribute(node, "title");
        }
        return "\"not an value'";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.getColumnAttr(n2);
        Node node = this.getRowRecord(n);
        String string2 = XCommonManager.getAttribute(node, string);
        if (string2.startsWith("#")) {
            return XCommonManager.getColor(string2);
        }
        return string2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.getColumnAttr(n2);
        Element element = (Element)this.getRowRecord(n);
        element.setAttribute(string, object.toString());
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, n2);
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Node node = this.getColumnRecord(n2);
        String string = XCommonManager.getAttribute(node, "editable", "false");
        return string == "true";
    }
}

