/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.ParamInfo;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.SyntaxMsg;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class WrongNumberOfTypeArgs
extends SyntaxMsg {
    private final Types.Type fntpe;
    private final List<ParamInfo> expectedArgs;
    private final List<Trees.Tree<Types.Type>> actual;
    private final int expectedCount;
    private final int actualCount;
    private final String msgPrefix;

    public WrongNumberOfTypeArgs(Types.Type fntpe, List<ParamInfo> expectedArgs, List<Trees.Tree<Types.Type>> actual, Contexts.Context x$4) {
        this.fntpe = fntpe;
        this.expectedArgs = expectedArgs;
        this.actual = actual;
        super(ErrorMessageID$.WrongNumberOfTypeArgsID, x$4);
        this.expectedCount = expectedArgs.length();
        this.actualCount = actual.length();
        this.msgPrefix = this.actualCount > this.expectedCount ? "Too many" : "Not enough";
    }

    @Override
    public String msg(Contexts.Context x$1) {
        String string;
        String expectedArgString = this.expectedArgs.map((Function1 & Serializable)_$7 -> NameOps$.MODULE$.unexpandedName(_$7.paramName(x$1)).show(x$1)).mkString("[", ", ", "]");
        String actualArgString = this.actual.map((Function1 & Serializable)_$8 -> _$8.show(x$1)).mkString("[", ", ", "]");
        try {
            Symbols.Symbol symbol = this.fntpe.termSymbol(x$1);
            if (Symbols$NoSymbol$.MODULE$.equals(symbol)) {
                string = this.fntpe.show(x$1);
            } else {
                Symbols.Symbol symbol2 = symbol;
                string = symbol2.showFullName(x$1);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                string = this.fntpe.show(x$1);
            }
            throw throwable;
        }
        String prettyName = string;
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|", " type arguments for ", "", "\n        |expected: ", "\n        |actual:   ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)this.msgPrefix), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)prettyName), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)expectedArgString), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)expectedArgString), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)actualArgString)}), x$1);
    }

    @Override
    public String explain(Contexts.Context x$1) {
        String tooManyTypeParams = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|val tuple2: (Int, String) = (1, \"one\")\n          |val list: List[(Int, String)] = List(tuple2)"));
        if (this.actualCount > this.expectedCount) {
            return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|You have supplied too many type parameters\n          |\n          |For example List takes a single type parameter (List[A])\n          |If you need to hold more types in a list then you need to combine them\n          |into another data type that can contain the number of types you need,\n          |In this example one solution would be to use a Tuple:\n          |\n          |", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)tooManyTypeParams)}), x$1);
        }
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|You have not supplied enough type parameters\n          |If you specify one type parameter then you need to specify every type parameter."})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$1);
    }
}

