//--------------------------------------------------------------
// Negative
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Negative", "Colour", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Level,    "Level",    "Threshold", kNoFlags, 0.0,  0.0, 1.0 );
DeclareFloatParam( Softness, "Softness", "Threshold", kNoFlags, 0.25, 0.0, 1.0 );

float _MaxSoftness = 0.2;

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
DeclareEntryPoint()
{
   float4 ret;

   float soft = Softness * _MaxSoftness;
   float softStart = Level - soft;

   // Get source pixel..
   float4 srcPixel = ReadPixel( Input, uv1 );

   float lum = ( srcPixel.r + srcPixel.g + srcPixel.b ) / 3.0;

   if ( lum >= Level )
   {
      // Calculate the inverse
      ret = 1.0 - srcPixel;
   }
   else if ( lum > softStart )
   {
      ret = lerp( srcPixel, 1.0 - srcPixel, ( lum - softStart ) / soft );
   }
   else
   {
      ret = srcPixel;
   }

   ret = lerp( srcPixel, ret, srcPixel.a );
   ret.a = srcPixel.a;

   return lerp( srcPixel, ret, tex2D( Mask, uv1 ) );
}
