//--------------------------------------------------------------
// Flip
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Flip", "DVE", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

DeclareIntParam( _InputOrientation );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float2 pos =
      ( ( _InputOrientation == 0 ) || ( _InputOrientation == 180 ) ) ? float2 ( uv1.x, 1.0 - uv1.y ) : float2 ( 1.0 - uv1.x, uv1.y );

   float4 source = ReadPixel( Input, uv1 );
   float4 flipVal = ReadPixel( Input, pos );

   return lerp( source, flipVal, tex2D( Mask, uv1 ) );
}
