//--------------------------------------------------------------
// Flat Colour Effects
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Colour Matte", "Mattes", "Components", kNoNotes, "CanSize|HasMinOutputSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareColourParam( Colour, "Colour", kNoGroup, kNoFlags, 1.0, 1.0, 1.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------

DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 bg = ReadPixel( Input, uv1 );
   float4 ret = lerp( bg, Colour, Colour.a );
   ret.a = bg.a;

   return lerp( bg, ret, tex2D( Mask, uv1 ) );
}
