//--------------------------------------------------------------//
// difference.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
#include "_utils.fx"

DeclareLightworksEffect( "Difference", "Mixes", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 ret = abs( fgPix - bgPix );
   ret.a = 1.0;

   return lerp( fgPix, ret, tex2D( Mask, uv1 ) );
}
