//--------------------------------------------------------------//
// BoxBlur
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "Box Blur";
   string Category    = "Stylize";
   bool CanSize       = false;
> = 0;

//--------------------------------------------------------------//
// Params
//--------------------------------------------------------------//

float Amount
<
   string Description = "Amount";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.5;

bool RedBlur
<
   string Description = "Red";
   string Group       = "Channels";
> = true;

bool GreenBlur
<
   string Description = "Green";
   string Group       = "Channels";
> = true;

bool BlueBlur
<
   string Description = "Blue";
   string Group       = "Channels";
> = true;

bool AlphaBlur
<
   string Description = "Alpha";
   string Group       = "Channels";
> = false;

float _OutputWidth  = 1.0;
float _OutputHeight = 1.0;

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
texture Input;
sampler InputSampler = sampler_state
{
   Texture = <Input>;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
   MAGFILTER = LINEAR;

};
texture Blur1 : RenderColorTarget < float2 ViewportRatio={1.0,1.0}; >;
sampler BlurSampler = sampler_state
{
   Texture = <Blur1>;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
   MAGFILTER = LINEAR;
};

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//

float4 blurX_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float one   = Amount / _OutputWidth;
   float tap1  = xy1.x + one;
   float tap2  = tap1 + one;
   float tap3  = tap2 + one;
   float tap4  = tap3 + one;
   float tap5  = tap4 + one;
   float tap6  = tap5 + one;
   float ntap1 = xy1.x - one;
   float ntap2 = ntap1 - one;
   float ntap3 = ntap2 - one;
   float ntap4 = ntap3 - one;
   float ntap5 = ntap4 - one;
   float ntap6 = ntap5 - one;

   float4 ret =  tex2D( InputSampler, xy1 );
   float4 blurred = ret;

   blurred += tex2D( InputSampler, float2( tap1,  xy1.y ) );
   blurred += tex2D( InputSampler, float2( tap2,  xy1.y ) );
   blurred += tex2D( InputSampler, float2( tap3,  xy1.y ) );
   blurred += tex2D( InputSampler, float2( tap4,  xy1.y ) );
   blurred += tex2D( InputSampler, float2( tap5,  xy1.y ) );
   blurred += tex2D( InputSampler, float2( tap6,  xy1.y ) );
   blurred += tex2D( InputSampler, float2( ntap1, xy1.y ) );
   blurred += tex2D( InputSampler, float2( ntap2, xy1.y ) );
   blurred += tex2D( InputSampler, float2( ntap3, xy1.y ) );
   blurred += tex2D( InputSampler, float2( ntap4, xy1.y ) );
   blurred += tex2D( InputSampler, float2( ntap5, xy1.y ) );
   blurred += tex2D( InputSampler, float2( ntap6, xy1.y ) );

   blurred /= 13;

   if ( RedBlur )
   {
      ret.r = blurred.r;
   }

   if ( GreenBlur )
   {
      ret.g = blurred.g;
   }

   if ( BlueBlur )
   {
      ret.b = blurred.b;
   }

   if ( AlphaBlur )
   {
      ret.a = blurred.a;
   }

   return ret;
}

//--------------------------------------------------------------//
float4 blurY_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float one  = Amount / _OutputHeight;
   float tap1 = xy1.y + one;
   float tap2 = tap1 + one;
   float tap3 = tap2 + one;;
   float tap4 = tap3 + one;
   float tap5 = tap4 + one;
   float tap6 = tap5 + one;

   float ntap1 = xy1.y - one;
   float ntap2 = ntap1 - one;
   float ntap3 = ntap2 - one;;
   float ntap4 = ntap3 - one;
   float ntap5 = ntap4 - one;
   float ntap6 = ntap5 - one;

   float4 ret =  tex2D( BlurSampler, xy1 );
   float4 blurred = ret;
   blurred += tex2D( BlurSampler, float2( xy1.x, tap1 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, tap2 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, tap3 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, tap4 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, tap5 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, tap6 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, ntap1 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, ntap2 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, ntap3 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, ntap4 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, ntap5 ) );
   blurred += tex2D( BlurSampler, float2( xy1.x, ntap6 ) );

   blurred /= 13;

   if ( RedBlur )
   {
      ret.r = blurred.r;
   }

   if ( GreenBlur )
   {
      ret.g = blurred.g;
   }

   if ( BlueBlur )
   {
      ret.b = blurred.b;
   }

   float4 source = tex2D( InputSampler, xy1 );
   ret = lerp( source, ret, source.a );

   if ( AlphaBlur )
   {
      ret.a = blurred.a;
   }

   return ret;
}

//--------------------------------------------------------------//
technique BoxBlur
{
   pass BlurX
   <
      string Script = "RenderColorTarget0 = Blur1;";
   >
   {
      PixelShader = compile PROFILE blurX_main();
   }

   pass BlurY
   {
      PixelShader = compile PROFILE blurY_main();
   }
}
