//--------------------------------------------------------------
// AlphaKey
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Alphakey", "Key", kNoSubCategory, kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );

//--------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 ret = float4( fgPix.a * fgPix ) + ( ( 1.0 - fgPix.a ) * bgPix );
   ret.a = 1.0;

   return ret;
}
