//--------------------------------------------------------------//
// YV12ToYUYV
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( YV12ToYUYV, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input );

bool isEven( float f )
{
  return ( ( 2 * floor( f / 2 ) ) == f );
}

DeclareFloatParam( _Width );
DeclareFloatParam( _Height );

DeclareEntryPoint()
{
   float x = floor( ( uv0.x * _Width ) + 0.5 );
   float y = floor( ( uv0.y * _Height ) + 0.5 );

   bool xEven = isEven( x );
   bool yEven = isEven( y );

   float yX = floor( x / 2 );

   if ( !yEven )
      yX += _Width/2;

   yX /= _Width;

   float uvX = ( uv0.x / 4 ) + ( fmod( y,4 ) * 0.25 );

   float4 yPixel = tex2D( Input, float2( yX, uv1.y / 2 ) );
   float4 uPixel = tex2D( Input, float2( uvX, 0.5  + ( uv1.y / 4 ) ) );
   float4 vPixel = tex2D( Input, float2( uvX, 0.75 + ( uv1.y / 4 ) ) );

   float4 yuyv;

   if ( xEven )
   {
      yuyv[0] = yPixel[1];
      yuyv[2] = yPixel[2];
   }
   else
   {
      yuyv[0] = yPixel[3];
      yuyv[2] = yPixel[0];
   }

   int uvIdx = int( fmod( x, 4 ) );
   yuyv[1] = uPixel[ uvIdx ];
   yuyv[3] = vPixel[ uvIdx ];

   return yuyv;
}

