//--------------------------------------------------------------
// YCbCr422ToRGB.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( YCbCr422ToRGB, Internal, Colour, kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( gSourceImage, Point, Clamp );

DeclareFloat3Param( ccCoefsAdd1 );
DeclareFloat3x3Param( ccCoefsMul2 );
DeclareFloat3Param( ccCoefsAdd3 );

int isOdd( int i )
{
   return ( ( 2 * ( i / 2 ) ) == i ) ? 0 : 1;
}

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   // Source pixels are stored as:
   // Cb = b, Y0 = g, Cr = r, Y1 = a

   // For each input BGRA pixel, Y0 is in pix[1], Y1 is in pix[3]
   float3 yuv;

   int q = isOdd(int(uv5.x));

   float4 src = tex2D( gSourceImage, uv2 );

   // Y
   yuv.r  = src[ q * 2 + 1 ];

   // UV
   yuv.gb = src.rb;

   float4 ret;

   ret.a = 1;

   ret.rgb = mul(yuv + ccCoefsAdd1, ccCoefsMul2) + ccCoefsAdd3;

   return ret;
}
