//--------------------------------------------------------------//
// VideoAnalyserHelpers.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

int _LwksEffectInfo
<
   string EffectGroup = "Internal";
> = 0;

float4 _TintMin;
float4 _TintMax;

float _GraticuleOpacity = 0.7;
float _Brightness = 1.0;

texture Graticule;
sampler GraticuleSampler = sampler_state
{
   Texture = <Graticule>;
   MINFILTER = POINT; //LINEAR;
   MAGFILTER = POINT; //LINEAR;
};

texture AnalyserImage;
sampler AnalyserImageSampler = sampler_state
{
   Texture = <AnalyserImage>;
   MINFILTER = LINEAR;
   MAGFILTER = LINEAR;
   ADDRESSU  = BORDER;
   ADDRESSV  = BORDER;
};

sampler AnalyserImageSamplerPt = sampler_state
{
   Texture = <AnalyserImage>;
   MINFILTER = POINT;
   MAGFILTER = POINT;
   ADDRESSU  = BORDER;
   ADDRESSV  = BORDER;
};

//-----------------------------------------------------------------------------------------------
// Vectorscope
//-----------------------------------------------------------------------------------------------

// From http://www.poynton.com/notes/short_subjects/video/YCbCr_to_RGB
//
//    Cb is (0.5/0.886)*(B'-Y') and Cr is (0.5/0.701)*(R'-Y')
//
// Hence :
//
const float _CBToV = 0.5 / 0.701;
const float _CRToU = 0.5 / 0.886;

float _XScale = 0.75;
float _YScale = -0.75;

float4 psVectorscope( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return tex2D( AnalyserImageSampler, xy1 ) * 4.0;
}

//-----------------------------------------------------------------------------------------------
float4 psVectorscopeWithGraticule( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float2 xy2 = ( ( xy1 - 0.5 ) * float2( _XScale / _CRToU, _YScale / _CBToV ) ) + 0.5;

   float4 value = tex2D( AnalyserImageSampler, xy2 );
   float4 graticulePixel = tex2D( GraticuleSampler, xy1 );

   return ( graticulePixel * _GraticuleOpacity ) + ( value * 4.0 );
}

//-----------------------------------------------------------------------------------------------
// Waveform
//-----------------------------------------------------------------------------------------------
float2 pixeloffsetV1 = float2( 0.0, 1.0 / 256.0 );
float2 pixeloffsetV2 = float2( 0.0, 2.0 / 256.0 );
float2 pixeloffsetV3 = float2( 0.0, 3.0 / 256.0 );

float4 psWaveformOverlayWithGraticule( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 rgbAnalysisPixel = tex2D( AnalyserImageSampler, float2( xy1.x, 1.0 - xy1.y ) );
   float4 graticulePixel   = tex2D( GraticuleSampler, xy1.xy );

   float4 ret = rgbAnalysisPixel.g;
   float scale = _Brightness * 4.0;

   if ( ret.g != 0 )
      ret *= scale;

   if ( rgbAnalysisPixel.r != 0 )
      ret.r += rgbAnalysisPixel.r * scale;

   if ( rgbAnalysisPixel.b != 0 )
      ret.b += rgbAnalysisPixel.b * scale;

   return ( graticulePixel * _GraticuleOpacity ) + ret;
}
//-----------------------------------------------------------------------------------------------
float4 psWaveformParadeWithGraticule( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 rgbAnalysisPixel = float4( 0,0,0,1.0 );
   float4 graticulePixel = tex2D( GraticuleSampler, xy1.xy );
   float scale = _Brightness * 4.0;


  if ( xy1.y < 0.5 )
   {
      xy1.y = 1.0 - ( xy1.y * 2.0 );

      float4 p1 = tex2D( AnalyserImageSampler, xy1 );

      float grey = p1.g;

      if ( grey != 0 )
         rgbAnalysisPixel = grey * scale;
   }
   else
   {
      if ( xy1.y > 0.75 )
      {
         xy1.y = 1.0 - ( ( xy1.y - 0.75 ) * 4.0 );

         float4 p1 = tex2D( AnalyserImageSampler, xy1 );
         float4 p2 = tex2D( AnalyserImageSampler, xy1 + pixeloffsetV1 );
         float4 p3 = tex2D( AnalyserImageSampler, xy1 + pixeloffsetV2 );
         float4 p4 = tex2D( AnalyserImageSampler, xy1 + pixeloffsetV3 );

         rgbAnalysisPixel.b = max( max( max( p1.b, p2.b ), p3.b ), p4.b );

         if ( rgbAnalysisPixel.b != 0 )
         {
            rgbAnalysisPixel.b = scale * rgbAnalysisPixel.b;
            rgbAnalysisPixel.rg = 0; //0.2;
         }
      }
      else
      {
         xy1.y = 1.0 - ( ( xy1.y - 0.5 ) * 4.0 );

         float4 p1 = tex2D( AnalyserImageSampler, xy1 );
         float4 p2 = tex2D( AnalyserImageSampler, xy1 + pixeloffsetV1 );
         float4 p3 = tex2D( AnalyserImageSampler, xy1 + pixeloffsetV2 );
         float4 p4 = tex2D( AnalyserImageSampler, xy1 + pixeloffsetV3 );

         rgbAnalysisPixel.r = max( max( max( p1.r, p2.r ), p3.r ), p4.r );

         if ( rgbAnalysisPixel.r != 0 )
         {
            rgbAnalysisPixel.r = scale * rgbAnalysisPixel.r;
            rgbAnalysisPixel.gb = 0; //0.2;
         }
      }
   }

   return ( graticulePixel * _GraticuleOpacity ) + rgbAnalysisPixel;
}

//-----------------------------------------------------------------------------------------------
float4 psGraticuleOnly( float2 xy1 : TEXCOORD1 ) : COLOR
{
   return _GraticuleOpacity * tex2D( GraticuleSampler, xy1.xy );
}

//-----------------------------------------------------------------------------------------------
// Techniques
//-----------------------------------------------------------------------------------------------
technique AnalyserOnlyTinted         { pass p0 { PixelShader = compile PROFILE psVectorscope(); } }
technique GraticuleOnly              { pass p0 { PixelShader = compile PROFILE psGraticuleOnly(); } }
technique GraticuleAndAnalyser       { pass p0 { PixelShader = compile PROFILE psWaveformOverlayWithGraticule(); } }
technique GraticuleAndAnalyserParade { pass p0 { PixelShader = compile PROFILE psWaveformParadeWithGraticule(); } }
technique GraticuleAndAnalyserTinted { pass p0 { PixelShader = compile PROFILE psVectorscopeWithGraticule(); } }

