//--------------------------------------------------------------//
// Stereoscopic.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "Null";
   string Category    = "Null";
> = 0;

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
texture Left;
texture Right;
sampler LeftSampler  = sampler_state { Texture = <Left>; };
sampler RightSampler = sampler_state { Texture = <Right>; };

const float _kCheckerSize = 0.1;

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//

// eSideBySide
float4 sideBySide_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 ret;

   if ( xy1.x < 0.5 )
   {
      ret = tex2D( LeftSampler, float2( xy1.x / 0.5, xy1.y ) );
   }
   else
   {
      ret = tex2D( RightSampler, float2( ( xy1.x - 0.5 ) / 0.5, xy1.y ) );
   }

   return ret;
}

// eSplitscreen
float4 splitscreen_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 ret;

   if ( xy1.x < 0.5 )
   {
      ret = tex2D( LeftSampler, xy1 );
   }
   else
   {
      ret = tex2D( RightSampler, xy1 );
   }

   return ret;
}

// eAnaglyphRedCyan
float4 anaglyphRedCyan_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 left  = tex2D( LeftSampler, xy1 );
   float4 right = tex2D( RightSampler, xy1 );

   float leftLuma  = ( left.r + left.g + left.b ) / 3.0;
   float rightLuma = ( right.r + right.g + right.b ) / 3.0;

   return float4( leftLuma, rightLuma, rightLuma, 1.0 );
}

// eAnaglyphAmberBlue
float4 anaglyphAmberBlue_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 left  = tex2D( LeftSampler, xy1 );
   float4 right = tex2D( RightSampler, xy1 );

   float leftLuma  = ( left.r + left.g + left.b ) / 3.0;
   float rightLuma = ( right.r + right.g + right.b ) / 3.0;

   return float4( leftLuma, leftLuma, rightLuma, 1.0 );
}

// eAnaglyphAmberBlueColour
float4 anaglyphAmberBlueColour_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 left  = tex2D( LeftSampler, xy1 );
   float4 right = tex2D( RightSampler, xy1 );

   float rightLuma = ( right.r * 0.15 ) + ( right.g * 0.15 ) + ( right.b * 0.7 );

   return float4( left.r, left.g, rightLuma, 1.0 );
}

// eAnaglyphGreenMagenta
float4 anaglyphGreenMagenta_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 left  = tex2D( LeftSampler, xy1 );
   float4 right = tex2D( RightSampler, xy1 );

   float leftLuma  = ( left.r + left.g + left.b ) / 3.0;
   float rightLuma = ( right.r + right.g + right.b ) / 3.0;

   return float4( rightLuma, leftLuma, rightLuma, 1.0 );
}

// eDifference
float4 diff_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 left  = tex2D( LeftSampler, xy1 );
   float4 right = tex2D( RightSampler, xy1 );
   float4 diff  = ( left - right ) + 0.5;

   return float4( diff.r, diff.g, diff.b, 1.0 );
}

bool isOdd( float f )
{
  return ( ( 2 * round( f / 2 ) ) == f );
}

// eCheckerboard
float4 checkerboard_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 ret;

   float2 checkerIndex = round( xy1 / _kCheckerSize );

   if ( isOdd( checkerIndex.x ) )
   {
      if ( isOdd( checkerIndex.y ) )
      {
         ret = tex2D( RightSampler, xy1 );  // Odd/Odd
      }
      else
      {
         ret = tex2D( LeftSampler, xy1 );   // Odd/Even
      }
   }
   else
   {
      if ( isOdd( checkerIndex.y ) )
      {
         ret = tex2D( LeftSampler, xy1 );   // Even/Odd
      }
      else
      {
         ret = tex2D( RightSampler, xy1 );  // Even/Even
      }
   }

   return ret;
}

//--------------------------------------------------------------//
// Techniques
//--------------------------------------------------------------//
technique SideBySide              { pass Single_Pass { PixelShader = compile PROFILE sideBySide_main(); } }
technique Splitscreen             { pass Single_Pass { PixelShader = compile PROFILE splitscreen_main(); } }
technique AnaglyphRedCyan         { pass Single_Pass { PixelShader = compile PROFILE anaglyphRedCyan_main(); } }
technique AnaglyphAmberBlue       { pass Single_Pass { PixelShader = compile PROFILE anaglyphAmberBlue_main(); } }
technique AnaglyphAmberBlueColour { pass Single_Pass { PixelShader = compile PROFILE anaglyphAmberBlueColour_main(); } }
technique AnaglyphGreenMagenta    { pass Single_Pass { PixelShader = compile PROFILE anaglyphGreenMagenta_main(); } }
technique Checkerboard            { pass Single_Pass { PixelShader = compile PROFILE checkerboard_main(); } }
technique Difference              { pass Single_Pass { PixelShader = compile PROFILE diff_main(); } }
