/* Generated by wayland-scanner 1.24.0 */

#ifndef XX_SESSION_MANAGEMENT_V1_SERVER_PROTOCOL_H
#define XX_SESSION_MANAGEMENT_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xx_session_management_v1 The xx_session_management_v1 protocol
 * Protocol for managing application sessions
 *
 * @section page_desc_xx_session_management_v1 Description
 *
 * This description provides a high-level overview of the interplay between
 * the interfaces defined this protocol. For details, see the protocol
 * specification.
 *
 * The xx_session_manager protocol declares interfaces necessary to
 * allow clients to restore toplevel state from previous executions. The
 * xx_session_manager_v1.get_session request can be used to obtain a
 * xx_session_v1 resource representing the state of a set of toplevels.
 *
 * Clients may obtain the session string to use in future calls through
 * the xx_session_v1.created event. Compositors will use this string
 * as an identifiable token for future runs, possibly storing data about
 * the related toplevels in persistent storage.
 *
 * Toplevels are managed through the xx_session_v1.add_toplevel and
 * xx_session_toplevel_v1.remove pair of requests. Clients will explicitly
 * request a toplevel to be restored according to prior state through the
 * xx_session_v1.restore_toplevel request before the toplevel is mapped.
 *
 * Warning! The protocol described in this file is currently in the
 * experimental phase. Backwards incompatible major versions of the
 * protocol are to be expected. Exposing this protocol without an opt-in
 * mechanism is discouraged.
 *
 * @section page_ifaces_xx_session_management_v1 Interfaces
 * - @subpage page_iface_xx_session_manager_v1 - manage sessions for applications
 * - @subpage page_iface_xx_session_v1 - A session for an application
 * - @subpage page_iface_xx_toplevel_session_v1 - 
 * @section page_copyright_xx_session_management_v1 Copyright
 * <pre>
 *
 * Copyright 2018 Mike Blumenkrantz
 * Copyright 2018 Samsung Electronics Co., Ltd
 * Copyright 2018 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct xdg_toplevel;
struct xx_session_manager_v1;
struct xx_session_v1;
struct xx_toplevel_session_v1;

#ifndef XX_SESSION_MANAGER_V1_INTERFACE
#define XX_SESSION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xx_session_manager_v1 xx_session_manager_v1
 * @section page_iface_xx_session_manager_v1_desc Description
 *
 * The xx_session_manager interface defines base requests for creating and
 * managing a session for an application. Sessions persist across application
 * and compositor restarts unless explicitly destroyed. A session is created
 * for the purpose of maintaining an application's xdg_toplevel surfaces
 * across compositor or application restarts. The compositor should remember
 * as many states as possible for surfaces in a given session, but there is
 * no requirement for which states must be remembered.
 * @section page_iface_xx_session_manager_v1_api API
 * See @ref iface_xx_session_manager_v1.
 */
/**
 * @defgroup iface_xx_session_manager_v1 The xx_session_manager_v1 interface
 *
 * The xx_session_manager interface defines base requests for creating and
 * managing a session for an application. Sessions persist across application
 * and compositor restarts unless explicitly destroyed. A session is created
 * for the purpose of maintaining an application's xdg_toplevel surfaces
 * across compositor or application restarts. The compositor should remember
 * as many states as possible for surfaces in a given session, but there is
 * no requirement for which states must be remembered.
 */
extern const struct wl_interface xx_session_manager_v1_interface;
#endif
#ifndef XX_SESSION_V1_INTERFACE
#define XX_SESSION_V1_INTERFACE
/**
 * @page page_iface_xx_session_v1 xx_session_v1
 * @section page_iface_xx_session_v1_desc Description
 *
 * A xx_session_v1 object represents a session for an application. While the
 * object exists, all surfaces which have been added to the session will
 * have states stored by the compositor which can be reapplied at a later
 * time. Two sessions cannot exist for the same identifier string.
 *
 * States for surfaces added to a session are automatically updated by the
 * compositor when they are changed.
 *
 * Surfaces which have been added to a session are automatically removed from
 * the session if xdg_toplevel.destroy is called for the surface.
 * @section page_iface_xx_session_v1_api API
 * See @ref iface_xx_session_v1.
 */
/**
 * @defgroup iface_xx_session_v1 The xx_session_v1 interface
 *
 * A xx_session_v1 object represents a session for an application. While the
 * object exists, all surfaces which have been added to the session will
 * have states stored by the compositor which can be reapplied at a later
 * time. Two sessions cannot exist for the same identifier string.
 *
 * States for surfaces added to a session are automatically updated by the
 * compositor when they are changed.
 *
 * Surfaces which have been added to a session are automatically removed from
 * the session if xdg_toplevel.destroy is called for the surface.
 */
extern const struct wl_interface xx_session_v1_interface;
#endif
#ifndef XX_TOPLEVEL_SESSION_V1_INTERFACE
#define XX_TOPLEVEL_SESSION_V1_INTERFACE
/**
 * @page page_iface_xx_toplevel_session_v1 xx_toplevel_session_v1
 * @section page_iface_xx_toplevel_session_v1_api API
 * See @ref iface_xx_toplevel_session_v1.
 */
/**
 * @defgroup iface_xx_toplevel_session_v1 The xx_toplevel_session_v1 interface
 */
extern const struct wl_interface xx_toplevel_session_v1_interface;
#endif

#ifndef XX_SESSION_MANAGER_V1_ERROR_ENUM
#define XX_SESSION_MANAGER_V1_ERROR_ENUM
enum xx_session_manager_v1_error {
	/**
	 * a requested session is already in use
	 */
	XX_SESSION_MANAGER_V1_ERROR_IN_USE = 1,
};
#endif /* XX_SESSION_MANAGER_V1_ERROR_ENUM */

#ifndef XX_SESSION_MANAGER_V1_ERROR_ENUM_IS_VALID
#define XX_SESSION_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xx_session_manager_v1
 * Validate a xx_session_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xx_session_manager_v1_error
 */
static inline bool
xx_session_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_SESSION_MANAGER_V1_ERROR_IN_USE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_SESSION_MANAGER_V1_ERROR_ENUM_IS_VALID */

#ifndef XX_SESSION_MANAGER_V1_REASON_ENUM
#define XX_SESSION_MANAGER_V1_REASON_ENUM
/**
 * @ingroup iface_xx_session_manager_v1
 * reason for getting a session
 *
 * The reason may determine in what way a session restores the window
 * management state of associated toplevels.
 *
 * For example newly launched applications might be launched on the active
 * workspace with restored size and position, while a recovered
 * applications might restore additional state such as active workspace and
 * stacking order.
 */
enum xx_session_manager_v1_reason {
	/**
	 * an app is newly launched
	 *
	 * A new app instance is launched, for example from an app
	 * launcher.
	 */
	XX_SESSION_MANAGER_V1_REASON_LAUNCH = 1,
	/**
	 * an app recovered
	 *
	 * A app instance is recovering from for example a compositor or
	 * app crash.
	 */
	XX_SESSION_MANAGER_V1_REASON_RECOVER = 2,
	/**
	 * an app restored
	 *
	 * A app instance is restored, for example part of a restored
	 * session, or restored from having been temporarily terminated due
	 * to resource constraints.
	 */
	XX_SESSION_MANAGER_V1_REASON_SESSION_RESTORE = 3,
};
#endif /* XX_SESSION_MANAGER_V1_REASON_ENUM */

#ifndef XX_SESSION_MANAGER_V1_REASON_ENUM_IS_VALID
#define XX_SESSION_MANAGER_V1_REASON_ENUM_IS_VALID
/**
 * @ingroup iface_xx_session_manager_v1
 * Validate a xx_session_manager_v1 reason value.
 *
 * @return true on success, false on error.
 * @ref xx_session_manager_v1_reason
 */
static inline bool
xx_session_manager_v1_reason_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_SESSION_MANAGER_V1_REASON_LAUNCH:
		return version >= 1;
	case XX_SESSION_MANAGER_V1_REASON_RECOVER:
		return version >= 1;
	case XX_SESSION_MANAGER_V1_REASON_SESSION_RESTORE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_SESSION_MANAGER_V1_REASON_ENUM_IS_VALID */

/**
 * @ingroup iface_xx_session_manager_v1
 * @struct xx_session_manager_v1_interface
 */
struct xx_session_manager_v1_interface {
	/**
	 * Destroy this object
	 *
	 * This has no effect other than to destroy the
	 * xx_session_manager object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create or restore a session
	 *
	 * Create a session object corresponding to either an existing
	 * session identified by the given session identifier string or a
	 * new session. While the session object exists, the session is
	 * considered to be "in use".
	 *
	 * If a identifier string represents a session that is currently
	 * actively in use by the the same client, an 'in_use' error is
	 * raised. If some other client is currently using the same
	 * session, the new session will replace managing the associated
	 * state.
	 *
	 * NULL is passed to initiate a new session. If an id is passed
	 * which does not represent a valid session, the compositor treats
	 * it as if NULL had been passed.
	 *
	 * A client is allowed to have any number of in use sessions at the
	 * same time.
	 * @param reason reason for session
	 * @param session the session to restore
	 */
	void (*get_session)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    uint32_t reason,
			    const char *session);
};


/**
 * @ingroup iface_xx_session_manager_v1
 */
#define XX_SESSION_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_manager_v1
 */
#define XX_SESSION_MANAGER_V1_GET_SESSION_SINCE_VERSION 1

#ifndef XX_SESSION_V1_ERROR_ENUM
#define XX_SESSION_V1_ERROR_ENUM
enum xx_session_v1_error {
	/**
	 * restore cannot be performed after initial toplevel commit
	 */
	XX_SESSION_V1_ERROR_INVALID_RESTORE = 1,
	/**
	 * toplevel name is already in used
	 */
	XX_SESSION_V1_ERROR_NAME_IN_USE = 2,
	/**
	 * toplevel was already mapped when restored
	 */
	XX_SESSION_V1_ERROR_ALREADY_MAPPED = 3,
};
#endif /* XX_SESSION_V1_ERROR_ENUM */

#ifndef XX_SESSION_V1_ERROR_ENUM_IS_VALID
#define XX_SESSION_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xx_session_v1
 * Validate a xx_session_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xx_session_v1_error
 */
static inline bool
xx_session_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_SESSION_V1_ERROR_INVALID_RESTORE:
		return version >= 1;
	case XX_SESSION_V1_ERROR_NAME_IN_USE:
		return version >= 1;
	case XX_SESSION_V1_ERROR_ALREADY_MAPPED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_SESSION_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_xx_session_v1
 * @struct xx_session_v1_interface
 */
struct xx_session_v1_interface {
	/**
	 * Destroy the session
	 *
	 * Destroy a session object, preserving the current state but not
	 * continuing to make further updates if state changes occur. This
	 * makes the associated xx_toplevel_session_v1 objects inert.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * Remove the session
	 *
	 * Remove the session, making it no longer available for
	 * restoration. A compositor should in response to this request
	 * remove the data related to this session from its storage.
	 */
	void (*remove)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * add a new surface to the session
	 *
	 * Attempt to add a given surface to the session. The passed name
	 * is used to identify what window is being restored, and may be
	 * used store window specific state within the session.
	 *
	 * Calling this with a toplevel that is already managed by the
	 * session with the same associated will raise an in_use error.
	 */
	void (*add_toplevel)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t id,
			     struct wl_resource *toplevel,
			     const char *name);
	/**
	 * restore a surface state
	 *
	 * Inform the compositor that the toplevel associated with the
	 * passed name should have its window management state restored.
	 *
	 * Calling this with a toplevel that is already managed by the
	 * session with the same associated will raise an in_use error.
	 *
	 * This request must be called prior to the first commit on the
	 * associated wl_surface, otherwise an already_mapped error is
	 * raised.
	 *
	 * As part of the initial configure sequence, if the toplevel was
	 * successfully restored, a xx_toplevel_session_v1.restored event
	 * is emitted. See the xx_toplevel_session_v1.restored event for
	 * further details.
	 */
	void (*restore_toplevel)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id,
				 struct wl_resource *toplevel,
				 const char *name);
};

#define XX_SESSION_V1_CREATED 0
#define XX_SESSION_V1_RESTORED 1
#define XX_SESSION_V1_REPLACED 2

/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_RESTORED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_REPLACED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_REMOVE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_ADD_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_RESTORE_TOPLEVEL_SINCE_VERSION 1

/**
 * @ingroup iface_xx_session_v1
 * Sends an created event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_session_v1_send_created(struct wl_resource *resource_, const char *id)
{
	wl_resource_post_event(resource_, XX_SESSION_V1_CREATED, id);
}

/**
 * @ingroup iface_xx_session_v1
 * Sends an restored event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_session_v1_send_restored(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_SESSION_V1_RESTORED);
}

/**
 * @ingroup iface_xx_session_v1
 * Sends an replaced event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_session_v1_send_replaced(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_SESSION_V1_REPLACED);
}

/**
 * @ingroup iface_xx_toplevel_session_v1
 * @struct xx_toplevel_session_v1_interface
 */
struct xx_toplevel_session_v1_interface {
	/**
	 * Destroy the object
	 *
	 * Destroy the object. This has no effect window management of
	 * the associated toplevel.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * remove a surface from the session
	 *
	 * Remove a specified surface from the session and render any
	 * corresponding xx_toplevel_session_v1 object inert. The
	 * compositor should remove any data related to the toplevel in the
	 * corresponding session from its internal storage.
	 */
	void (*remove)(struct wl_client *client,
		       struct wl_resource *resource);
};

#define XX_TOPLEVEL_SESSION_V1_RESTORED 0

/**
 * @ingroup iface_xx_toplevel_session_v1
 */
#define XX_TOPLEVEL_SESSION_V1_RESTORED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_toplevel_session_v1
 */
#define XX_TOPLEVEL_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_toplevel_session_v1
 */
#define XX_TOPLEVEL_SESSION_V1_REMOVE_SINCE_VERSION 1

/**
 * @ingroup iface_xx_toplevel_session_v1
 * Sends an restored event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_toplevel_session_v1_send_restored(struct wl_resource *resource_, struct wl_resource *surface)
{
	wl_resource_post_event(resource_, XX_TOPLEVEL_SESSION_V1_RESTORED, surface);
}

#ifdef  __cplusplus
}
#endif

#endif
