
#ifndef KPEOPLE_EXPORT_H
#define KPEOPLE_EXPORT_H

#ifdef KPEOPLE_STATIC_DEFINE
#  define KPEOPLE_EXPORT
#  define KPEOPLE_NO_EXPORT
#else
#  ifndef KPEOPLE_EXPORT
#    ifdef KF6People_EXPORTS
        /* We are building this library */
#      define KPEOPLE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KPEOPLE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KPEOPLE_NO_EXPORT
#    define KPEOPLE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KPEOPLE_DECL_DEPRECATED
#  define KPEOPLE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KPEOPLE_DECL_DEPRECATED_EXPORT
#  define KPEOPLE_DECL_DEPRECATED_EXPORT KPEOPLE_EXPORT KPEOPLE_DECL_DEPRECATED
#endif

#ifndef KPEOPLE_DECL_DEPRECATED_NO_EXPORT
#  define KPEOPLE_DECL_DEPRECATED_NO_EXPORT KPEOPLE_NO_EXPORT KPEOPLE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KPEOPLE_NO_DEPRECATED
#    define KPEOPLE_NO_DEPRECATED
#  endif
#endif
#include <kpeople_version.h>

#define KPEOPLE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KPEOPLE_NO_DEPRECATED) && !defined(KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KPEOPLE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KPEOPLE_NO_DEPRECATED_WARNINGS) && !defined(KPEOPLE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KPEOPLE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KPEOPLE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KPEOPLE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KPEOPLE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KPEOPLE_NO_DEPRECATED)
#  undef KPEOPLE_DEPRECATED
#  define KPEOPLE_DEPRECATED_EXPORT KPEOPLE_EXPORT
#  define KPEOPLE_DEPRECATED_NO_EXPORT KPEOPLE_NO_EXPORT
#elif defined(KPEOPLE_NO_DEPRECATED_WARNINGS)
#  define KPEOPLE_DEPRECATED
#  define KPEOPLE_DEPRECATED_EXPORT KPEOPLE_EXPORT
#  define KPEOPLE_DEPRECATED_NO_EXPORT KPEOPLE_NO_EXPORT
#else
#  define KPEOPLE_DEPRECATED KPEOPLE_DECL_DEPRECATED
#  define KPEOPLE_DEPRECATED_EXPORT KPEOPLE_DECL_DEPRECATED_EXPORT
#  define KPEOPLE_DEPRECATED_NO_EXPORT KPEOPLE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KPEOPLE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KPEOPLE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KPEOPLE_NO_DEPRECATED
#  define KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT KPEOPLE_VERSION
#endif
#ifdef KPEOPLE_NO_DEPRECATED_WARNINGS
#  define KPEOPLE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KPEOPLE_DEPRECATED_WARNINGS_SINCE
#  ifdef KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KPEOPLE_DEPRECATED_WARNINGS_SINCE KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KPEOPLE_DEPRECATED_WARNINGS_SINCE KPEOPLE_VERSION
#  endif
#endif

#ifndef KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KPEOPLE_DEPRECATED
#  define KPEOPLE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KPEOPLE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KPEOPLE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KPEOPLE_EXPORT_H */
