/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.p3;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.primavera.common.ColumnDefinition;
import net.sf.mpxj.primavera.common.RowValidator;
import net.sf.mpxj.primavera.common.Table;
import net.sf.mpxj.primavera.common.TableDefinition;

class TableReader {
    private final TableDefinition m_definition;

    public TableReader(TableDefinition definition) {
        this.m_definition = definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, Table table) throws IOException {
        InputStream is = null;
        try {
            is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            this.read(is, table);
        }
        catch (Throwable throwable) {
            AutoCloseableHelper.closeQuietly(is);
            throw throwable;
        }
        AutoCloseableHelper.closeQuietly(is);
    }

    private void read(InputStream is, Table table) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[this.m_definition.getPageSize()];
        while ((bytesRead = is.read(buffer)) != -1) {
            if (bytesRead != buffer.length) {
                throw new IOException("Unexpected end of file");
            }
            this.readPage(buffer, table);
        }
    }

    private void readPage(byte[] buffer, Table table) {
        int magicNumber = this.getShort(buffer, 0);
        if (magicNumber == 17408) {
            int recordSize = this.m_definition.getRecordSize();
            RowValidator rowValidator = this.m_definition.getRowValidator();
            String primaryKeyColumnName = this.m_definition.getPrimaryKeyColumnName();
            int index = 6;
            while (index + recordSize <= buffer.length) {
                int btrieveValue = this.getShort(buffer, index);
                if (btrieveValue != 0) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("ROW_VERSION", btrieveValue);
                    for (ColumnDefinition column : this.m_definition.getColumns()) {
                        Object value = column.read(index, buffer);
                        row.put(column.getName(), value);
                    }
                    if (rowValidator == null || rowValidator.validRow(row)) {
                        table.addRow(primaryKeyColumnName, row);
                    }
                }
                index += recordSize;
            }
        }
    }

    private int getShort(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }
}

