/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractWrappedValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class ConverterValueModel
extends AbstractWrappedValueModel {
    private final ValueModel source;
    private final BindingConverter converter;

    public ConverterValueModel(ValueModel source, BindingConverter converter) {
        super(source);
        this.source = source;
        this.converter = converter;
    }

    public Object convertFromSubject(Object sourceValue) {
        return this.converter.targetValue(sourceValue);
    }

    @Override
    public void setValue(Object targetValue) {
        this.source.setValue(this.converter.sourceValue(targetValue));
    }

    @Override
    public Object getValue() {
        return this.convertFromSubject(this.source.getValue());
    }

    @Override
    protected PropertyChangeListener createValueChangeHandler() {
        return new ValueChangeHandler();
    }

    private final class ValueChangeHandler
    implements PropertyChangeListener {
        private ValueChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object convertedOldValue = evt.getOldValue() == null ? null : ConverterValueModel.this.convertFromSubject(evt.getOldValue());
            Object convertedNewValue = evt.getNewValue() == null ? null : ConverterValueModel.this.convertFromSubject(evt.getNewValue());
            ConverterValueModel.this.fireValueChange(convertedOldValue, convertedNewValue);
        }
    }
}

